/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import java.io.File;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyEvent;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.FileBrowserWidget;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportBaseWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ExportBaseToPage
extends WizardPage {
    protected ExportBaseWizard wizard;
    protected FileBrowserWidget fileBrowserWidget;
    protected Button overwriteFileButton;

    public ExportBaseToPage(String pageName, ExportBaseWizard wizard) {
        super(pageName);
        this.setPageComplete(false);
        this.setTitle(NLS.bind((String)Messages.getString("ExportBaseToPage.FileType"), (Object)this.getFileType()));
        this.setDescription(NLS.bind((String)Messages.getString("ExportBaseToPage.PleaseEnterTargetFile"), (Object)this.getFileType()));
        this.wizard = wizard;
    }

    protected void validate() {
        boolean ok = true;
        File file = new File(this.fileBrowserWidget.getFilename());
        if ("".equals(this.fileBrowserWidget.getFilename())) {
            this.setErrorMessage(null);
            ok = false;
        } else if (file.isDirectory()) {
            this.setErrorMessage(NLS.bind((String)Messages.getString("ExportBaseToPage.ErrorNotAFile"), (Object[])new String[]{this.getFileType()}));
            ok = false;
        } else if (file.exists() && !this.overwriteFileButton.getSelection()) {
            this.setErrorMessage(NLS.bind((String)Messages.getString("ExportBaseToPage.ErrorFileExists"), (Object[])new String[]{this.getFileType(), this.getFileType(), this.getFileType()}));
            ok = false;
        } else if (file.exists() && !file.canWrite()) {
            this.setErrorMessage(NLS.bind((String)Messages.getString("ExportBaseToPage.ErrorFileNotWritable"), (Object[])new String[]{this.getFileType()}));
            ok = false;
        } else if (file.getParentFile() == null) {
            this.setErrorMessage(NLS.bind((String)Messages.getString("ExportBaseToPage.ErrorDirectoryNotWritable"), (Object[])new String[]{this.getFileType()}));
            ok = false;
        }
        if (ok) {
            this.setErrorMessage(null);
        }
        this.setPageComplete(ok && this.wizard.getExportFilename() != null && !"".equals(this.wizard.getExportFilename()));
    }

    public void createControl(Composite composite) {
        BaseWidgetUtils.createLabel((Composite)composite, (String)NLS.bind((String)Messages.getString("ExportBaseToPage.FileTypeColon"), (Object)this.getFileType()), (int)1);
        this.fileBrowserWidget = new FileBrowserWidget(NLS.bind((String)Messages.getString("ExportBaseToPage.SelectFileType"), (Object[])new String[]{this.getFileType()}), this.getExtensions(), 8192);
        this.fileBrowserWidget.createWidget(composite);
        this.fileBrowserWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                ExportBaseToPage.this.wizard.setExportFilename(ExportBaseToPage.this.fileBrowserWidget.getFilename());
                ExportBaseToPage.this.validate();
            }
        });
        BaseWidgetUtils.createRadioIndent((Composite)composite, (int)1);
        this.overwriteFileButton = BaseWidgetUtils.createCheckbox((Composite)composite, (String)NLS.bind((String)Messages.getString("ExportBaseToPage.OverwriteExistingFile"), (Object[])new String[]{this.getFileType()}), (int)2);
        this.overwriteFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportBaseToPage.this.validate();
            }
        });
        this.fileBrowserWidget.setFocus();
        this.setControl((Control)composite);
        this.validate();
    }

    protected abstract String[] getExtensions();

    protected abstract String getFileType();

    public void saveDialogSettings() {
        this.fileBrowserWidget.saveDialogSettings();
    }
}

