/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.actions;

import java.io.File;
import org.apache.directory.studio.apacheds.configuration.ApacheDS2ConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.ApacheDS2ConfigurationPluginConstants;
import org.apache.directory.studio.apacheds.configuration.actions.Messages;
import org.apache.directory.studio.apacheds.configuration.editor.Configuration;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.jobs.LoadConfigurationRunnable;
import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class EditorImportConfigurationAction
extends Action {
    private static final String DIALOG_TITLE = Messages.getString("EditorImportConfigurationAction.SelectConfigurationFile");
    private ServerConfigurationEditor editor;

    public EditorImportConfigurationAction(ServerConfigurationEditor editor) {
        this.editor = editor;
    }

    public ImageDescriptor getImageDescriptor() {
        return ApacheDS2ConfigurationPlugin.getDefault().getImageDescriptor("resources/icons/import.gif");
    }

    public String getText() {
        return Messages.getString("EditorImportConfigurationAction.ImportConfiguration");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            ElementTreeSelectionDialog dialog;
            if (this.editor.isDirty() && !MessageDialog.openConfirm((Shell)this.editor.getSite().getShell(), (String)Messages.getString("EditorImportConfigurationAction.UnsavedModifications"), (String)Messages.getString("EditorImportConfigurationAction.ConfigurationHasUnsavedModificationsSureToContinue"))) {
                return;
            }
            File file = null;
            boolean isIDE = CommonUIUtils.isIDEEnvironment();
            if (isIDE) {
                dialog = this.createWorkspaceFileSelectionDialog();
                if (dialog.open() != 0) return;
                Object firstResult = dialog.getFirstResult();
                if (firstResult instanceof IFile) {
                    file = ((IFile)firstResult).getLocation().toFile();
                }
            } else {
                dialog = new FileDialog(this.editor.getSite().getShell(), 4100);
                dialog.setText(DIALOG_TITLE);
                dialog.setFilterPath(System.getProperty("user.home"));
                String filePath = dialog.open();
                if (filePath == null) {
                    return;
                }
                file = new File(filePath);
                if (!(file.exists() && file.isFile() && file.canRead())) {
                    return;
                }
            }
            if (file == null) {
                return;
            }
            if (!MessageDialog.openConfirm((Shell)this.editor.getSite().getShell(), (String)Messages.getString("EditorImportConfigurationAction.OverwriteExistingConfiguration"), (String)Messages.getString("EditorImportConfigurationAction.AreYouSureYouWantToOverwriteTheExistingConfiguration"))) {
                return;
            }
            Configuration configuration = LoadConfigurationRunnable.readConfiguration(file);
            this.editor.resetConfiguration(configuration);
            return;
        }
        catch (Exception e) {
            ApacheDS2ConfigurationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.apache.directory.studio.apacheds.configuration", e.getMessage()));
            MessageDialog.openError((Shell)this.editor.getSite().getShell(), (String)Messages.getString("EditorImportConfigurationAction.ErrorImportingConfigurationFile"), (String)NLS.bind((String)Messages.getString("EditorImportConfigurationAction.AnErrorOccurredWhenImportingTheSelectedFile"), (Object)e.getMessage()));
        }
    }

    private ElementTreeSelectionDialog createWorkspaceFileSelectionDialog() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.editor.getSite().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setMessage(Messages.getString("EditorImportConfigurationAction.SelectConfigurationFileToImport"));
        dialog.setTitle(DIALOG_TITLE);
        dialog.setAllowMultiple(false);
        dialog.setStatusLineAboveButtons(false);
        dialog.setValidator(new ISelectionStatusValidator(){
            private Status validated = new Status(0, ApacheDS2ConfigurationPluginConstants.PLUGIN_ID, 0, "", null);
            private Status notValidated = new Status(4, ApacheDS2ConfigurationPluginConstants.PLUGIN_ID, 4, "", null);

            public IStatus validate(Object[] selection) {
                Object selectedObject;
                if (selection != null && selection.length > 0 && (selectedObject = selection[0]) instanceof IFile) {
                    return this.validated;
                }
                return this.notValidated;
            }
        });
        return dialog;
    }
}

