/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.alias;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.schemaeditor.model.alias.Alias;
import org.apache.directory.studio.schemaeditor.model.alias.AliasWithPartError;
import org.apache.directory.studio.schemaeditor.model.alias.AliasWithStartError;
import org.apache.directory.studio.schemaeditor.model.alias.AliasesStringScanner;
import org.apache.directory.studio.schemaeditor.model.alias.AliasesStringToken;
import org.apache.directory.studio.schemaeditor.model.alias.DefaultAlias;

public class AliasesStringParser {
    private AliasesStringScanner scanner = new AliasesStringScanner();
    private List<Alias> aliases = new ArrayList<Alias>();

    public List<Alias> getAliases() {
        return this.aliases;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parse(String str) {
        this.aliases.clear();
        this.scanner.reset(str);
        AliasesStringToken token = this.scanner.nextToken();
        block5: do {
            switch (token.getType()) {
                case 2: {
                    this.aliases.add(new DefaultAlias(token.getValue()));
                    break;
                }
                case 3: {
                    String previousTokenValue = token.getValue();
                    token = this.scanner.nextToken();
                    if (token.getType() == 5) {
                        this.aliases.add(new AliasWithStartError(String.valueOf(previousTokenValue) + token.getValue(), previousTokenValue.charAt(0)));
                        break;
                    }
                    this.aliases.add(new AliasWithStartError(previousTokenValue, previousTokenValue.charAt(0)));
                    continue block5;
                }
                case 4: {
                    String previousTokenValue = token.getValue();
                    token = this.scanner.nextToken();
                    if (token.getType() == 5) {
                        this.aliases.add(new AliasWithPartError(String.valueOf(previousTokenValue) + token.getValue(), previousTokenValue.charAt(previousTokenValue.length() - 1)));
                        break;
                    }
                    this.aliases.add(new AliasWithPartError(previousTokenValue, previousTokenValue.charAt(previousTokenValue.length() - 1)));
                    continue block5;
                }
            }
            token = this.scanner.nextToken();
        } while (token.getType() != -1);
    }
}

