/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.style;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.attribute.fo.FoColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoCountryAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoFontSizeAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoFontStyleAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoFontWeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoLanguageAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleCountryAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleCountryComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontNameAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontNameComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontSizeAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontSizeComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontStyleAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontStyleComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontWeightAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontWeightComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLanguageAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLanguageComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextLineThroughColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextLineThroughStyleAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextUnderlineColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextUnderlineStyleAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextUnderlineWidthAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeFontFaceDeclsElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFontFaceElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.style.Font;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextProperties {
    StyleTextPropertiesElement mElement;

    protected TextProperties() {
    }

    protected TextProperties(StyleTextPropertiesElement textProperties) {
        this.mElement = textProperties;
    }

    public StyleTypeDefinitions.FontStyle getFontStyle() {
        String fontstyle = this.mElement.getFoFontStyleAttribute();
        String fontweight = this.mElement.getFoFontWeightAttribute();
        StyleTypeDefinitions.OdfFontStyle theFontType = StyleTypeDefinitions.OdfFontStyle.enumValueOf(fontstyle);
        StyleTypeDefinitions.OdfFontWeight theFontWeight = StyleTypeDefinitions.OdfFontWeight.enumValueOf(fontweight);
        if (theFontType == StyleTypeDefinitions.OdfFontStyle.NORMAL && theFontWeight == StyleTypeDefinitions.OdfFontWeight.NORMAL) {
            return StyleTypeDefinitions.FontStyle.REGULAR;
        }
        if (theFontType == StyleTypeDefinitions.OdfFontStyle.ITALIC && theFontWeight == StyleTypeDefinitions.OdfFontWeight.NORMAL) {
            return StyleTypeDefinitions.FontStyle.ITALIC;
        }
        if (theFontType == StyleTypeDefinitions.OdfFontStyle.ITALIC && theFontWeight == StyleTypeDefinitions.OdfFontWeight.BOLD) {
            return StyleTypeDefinitions.FontStyle.BOLDITALIC;
        }
        if (theFontType == StyleTypeDefinitions.OdfFontStyle.NORMAL && theFontWeight == StyleTypeDefinitions.OdfFontWeight.BOLD) {
            return StyleTypeDefinitions.FontStyle.BOLD;
        }
        return null;
    }

    public StyleTypeDefinitions.TextLinePosition getTextLineStyle() {
        String throughLine = this.mElement.getStyleTextLineThroughStyleAttribute();
        String underLine = this.mElement.getStyleTextUnderlineStyleAttribute();
        if (throughLine == null && underLine == null) {
            return StyleTypeDefinitions.TextLinePosition.REGULAR;
        }
        if (throughLine != null && underLine == null) {
            return StyleTypeDefinitions.TextLinePosition.THROUGH;
        }
        if (throughLine != null && underLine != null) {
            return StyleTypeDefinitions.TextLinePosition.THROUGHUNDER;
        }
        if (throughLine == null && underLine != null) {
            return StyleTypeDefinitions.TextLinePosition.UNDER;
        }
        return null;
    }

    public StyleTypeDefinitions.FontStyle getFontStyle(Document.ScriptType type) {
        if (type == null) {
            type = Document.ScriptType.WESTERN;
        }
        String fontstyle = null;
        String fontweight = null;
        switch (type) {
            case WESTERN: {
                fontstyle = this.mElement.getFoFontStyleAttribute();
                fontweight = this.mElement.getFoFontWeightAttribute();
                break;
            }
            case CJK: {
                fontstyle = this.mElement.getStyleFontStyleAsianAttribute();
                fontweight = this.mElement.getStyleFontWeightAsianAttribute();
                break;
            }
            case CTL: {
                fontstyle = this.mElement.getStyleFontStyleComplexAttribute();
                fontweight = this.mElement.getStyleFontWeightComplexAttribute();
            }
        }
        StyleTypeDefinitions.OdfFontStyle theFontType = StyleTypeDefinitions.OdfFontStyle.enumValueOf(fontstyle);
        StyleTypeDefinitions.OdfFontWeight theFontWeight = StyleTypeDefinitions.OdfFontWeight.enumValueOf(fontweight);
        if (theFontType == StyleTypeDefinitions.OdfFontStyle.NORMAL && theFontWeight == StyleTypeDefinitions.OdfFontWeight.NORMAL) {
            return StyleTypeDefinitions.FontStyle.REGULAR;
        }
        if (theFontType == StyleTypeDefinitions.OdfFontStyle.ITALIC && theFontWeight == StyleTypeDefinitions.OdfFontWeight.NORMAL) {
            return StyleTypeDefinitions.FontStyle.ITALIC;
        }
        if (theFontType == StyleTypeDefinitions.OdfFontStyle.ITALIC && theFontWeight == StyleTypeDefinitions.OdfFontWeight.BOLD) {
            return StyleTypeDefinitions.FontStyle.BOLDITALIC;
        }
        if (theFontType == StyleTypeDefinitions.OdfFontStyle.NORMAL && theFontWeight == StyleTypeDefinitions.OdfFontWeight.BOLD) {
            return StyleTypeDefinitions.FontStyle.BOLD;
        }
        return null;
    }

    public void setFontStyle(StyleTypeDefinitions.FontStyle style) {
        switch (style) {
            case BOLD: {
                this.mElement.removeAttribute(FoFontStyleAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.setFoFontWeightAttribute(StyleTypeDefinitions.OdfFontWeight.BOLD.toString());
                break;
            }
            case ITALIC: {
                this.mElement.setFoFontStyleAttribute(StyleTypeDefinitions.OdfFontStyle.ITALIC.toString());
                this.mElement.removeAttribute(FoFontWeightAttribute.ATTRIBUTE_NAME.getQName());
                break;
            }
            case BOLDITALIC: {
                this.mElement.setFoFontStyleAttribute(StyleTypeDefinitions.OdfFontStyle.ITALIC.toString());
                this.mElement.setFoFontWeightAttribute(StyleTypeDefinitions.OdfFontWeight.BOLD.toString());
                break;
            }
            case REGULAR: {
                this.mElement.removeAttribute(FoFontStyleAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(FoFontWeightAttribute.ATTRIBUTE_NAME.getQName());
            }
        }
    }

    public void setTextLineStyle(StyleTypeDefinitions.TextLinePosition style) {
        switch (style) {
            case THROUGH: {
                this.mElement.setStyleTextLineThroughStyleAttribute(StyleTypeDefinitions.LineStyle.SOLID.toString());
                this.mElement.setStyleTextLineThroughColorAttribute("font-color");
                break;
            }
            case UNDER: {
                this.mElement.setStyleTextUnderlineStyleAttribute(StyleTypeDefinitions.LineStyle.SOLID.toString());
                this.mElement.setStyleTextUnderlineWidthAttribute("auto");
                this.mElement.setStyleTextUnderlineColorAttribute("font-color");
                break;
            }
            case THROUGHUNDER: {
                this.mElement.setStyleTextLineThroughStyleAttribute(StyleTypeDefinitions.LineStyle.SOLID.toString());
                this.mElement.setStyleTextLineThroughColorAttribute("font-color");
                this.mElement.setStyleTextUnderlineStyleAttribute(StyleTypeDefinitions.LineStyle.SOLID.toString());
                this.mElement.setStyleTextUnderlineWidthAttribute("auto");
                this.mElement.setStyleTextUnderlineColorAttribute("font-color");
                break;
            }
            case REGULAR: {
                this.mElement.removeAttribute(StyleTextLineThroughStyleAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleTextLineThroughColorAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleTextUnderlineStyleAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleTextUnderlineWidthAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleTextUnderlineColorAttribute.ATTRIBUTE_NAME.getQName());
            }
        }
    }

    public void setFontStyle(StyleTypeDefinitions.FontStyle style, Document.ScriptType type) {
        if (type == null) {
            type = Document.ScriptType.WESTERN;
        }
        block0 : switch (type) {
            case WESTERN: {
                switch (style) {
                    case BOLD: {
                        this.mElement.removeAttribute(FoFontStyleAttribute.ATTRIBUTE_NAME.getQName());
                        this.mElement.setFoFontWeightAttribute(StyleTypeDefinitions.OdfFontWeight.BOLD.toString());
                        break;
                    }
                    case ITALIC: {
                        this.mElement.setFoFontStyleAttribute(StyleTypeDefinitions.OdfFontStyle.ITALIC.toString());
                        this.mElement.removeAttribute(FoFontWeightAttribute.ATTRIBUTE_NAME.getQName());
                        break;
                    }
                    case BOLDITALIC: {
                        this.mElement.setFoFontStyleAttribute(StyleTypeDefinitions.OdfFontStyle.ITALIC.toString());
                        this.mElement.setFoFontWeightAttribute(StyleTypeDefinitions.OdfFontWeight.BOLD.toString());
                        break;
                    }
                    case REGULAR: {
                        this.mElement.removeAttribute(FoFontStyleAttribute.ATTRIBUTE_NAME.getQName());
                        this.mElement.removeAttribute(FoFontWeightAttribute.ATTRIBUTE_NAME.getQName());
                    }
                }
                break;
            }
            case CJK: {
                switch (style) {
                    case BOLD: {
                        this.mElement.removeAttribute(StyleFontStyleAsianAttribute.ATTRIBUTE_NAME.getQName());
                        this.mElement.setStyleFontWeightAsianAttribute(StyleTypeDefinitions.OdfFontWeight.BOLD.toString());
                        break;
                    }
                    case ITALIC: {
                        this.mElement.setStyleFontStyleAsianAttribute(StyleTypeDefinitions.OdfFontStyle.ITALIC.toString());
                        this.mElement.removeAttribute(StyleFontWeightAsianAttribute.ATTRIBUTE_NAME.getQName());
                        break;
                    }
                    case BOLDITALIC: {
                        this.mElement.setStyleFontStyleAsianAttribute(StyleTypeDefinitions.OdfFontStyle.ITALIC.toString());
                        this.mElement.setStyleFontWeightAsianAttribute(StyleTypeDefinitions.OdfFontWeight.BOLD.toString());
                        break;
                    }
                    case REGULAR: {
                        this.mElement.removeAttribute(StyleFontStyleAsianAttribute.ATTRIBUTE_NAME.getQName());
                        this.mElement.removeAttribute(StyleFontWeightAsianAttribute.ATTRIBUTE_NAME.getQName());
                    }
                }
                break;
            }
            case CTL: {
                switch (style) {
                    case BOLD: {
                        this.mElement.removeAttribute(StyleFontStyleComplexAttribute.ATTRIBUTE_NAME.getQName());
                        this.mElement.setStyleFontWeightComplexAttribute(StyleTypeDefinitions.OdfFontWeight.BOLD.toString());
                        break block0;
                    }
                    case ITALIC: {
                        this.mElement.setStyleFontStyleComplexAttribute(StyleTypeDefinitions.OdfFontStyle.ITALIC.toString());
                        this.mElement.removeAttribute(StyleFontWeightComplexAttribute.ATTRIBUTE_NAME.getQName());
                        break block0;
                    }
                    case BOLDITALIC: {
                        this.mElement.setStyleFontStyleComplexAttribute(StyleTypeDefinitions.OdfFontStyle.ITALIC.toString());
                        this.mElement.setStyleFontWeightComplexAttribute(StyleTypeDefinitions.OdfFontWeight.BOLD.toString());
                        break block0;
                    }
                    case REGULAR: {
                        this.mElement.removeAttribute(StyleFontStyleComplexAttribute.ATTRIBUTE_NAME.getQName());
                        this.mElement.removeAttribute(StyleFontWeightComplexAttribute.ATTRIBUTE_NAME.getQName());
                    }
                }
            }
        }
    }

    public double getFontSizeInPoint() {
        String fontsize = this.mElement.getFoFontSizeAttribute();
        if (fontsize.endsWith("pt")) {
            double iSize;
            fontsize = fontsize.substring(0, fontsize.length() - 2);
            try {
                iSize = Double.parseDouble(fontsize.trim());
            }
            catch (Exception e) {
                iSize = 0.0;
            }
            return iSize;
        }
        return 0.0;
    }

    public double getFontSizeInPoint(Document.ScriptType type) {
        String fontsize = "";
        switch (type) {
            case WESTERN: {
                fontsize = this.mElement.getFoFontSizeAttribute();
                break;
            }
            case CJK: {
                fontsize = this.mElement.getStyleFontSizeAsianAttribute();
                break;
            }
            case CTL: {
                fontsize = this.mElement.getStyleFontSizeComplexAttribute();
            }
        }
        if (fontsize != null && fontsize.endsWith("pt")) {
            double iSize;
            fontsize = fontsize.substring(0, fontsize.length() - 2);
            try {
                iSize = Double.parseDouble(fontsize.trim());
            }
            catch (Exception e) {
                iSize = 0.0;
            }
            return iSize;
        }
        return 0.0;
    }

    public void setFontSizeInPoint(double size) {
        this.setFontSizeInPoint(size, Document.ScriptType.WESTERN);
    }

    public void setFontSizeInPoint(double size, Document.ScriptType type) {
        if (size < 0.0) {
            switch (type) {
                case WESTERN: {
                    this.mElement.removeAttribute(FoFontSizeAttribute.ATTRIBUTE_NAME.getQName());
                    break;
                }
                case CJK: {
                    this.mElement.removeAttribute(StyleFontSizeAsianAttribute.ATTRIBUTE_NAME.getQName());
                    break;
                }
                case CTL: {
                    this.mElement.removeAttribute(StyleFontSizeComplexAttribute.ATTRIBUTE_NAME.getQName());
                }
            }
            return;
        }
        switch (type) {
            case WESTERN: {
                this.mElement.setFoFontSizeAttribute(size + "pt");
                break;
            }
            case CJK: {
                this.mElement.setStyleFontSizeAsianAttribute(size + "pt");
                break;
            }
            case CTL: {
                this.mElement.setStyleFontSizeComplexAttribute(size + "pt");
            }
        }
    }

    public String getLanguage() {
        return this.getLanguage(Document.ScriptType.WESTERN);
    }

    public String getLanguage(Document.ScriptType type) {
        switch (type) {
            case WESTERN: {
                return this.mElement.getFoLanguageAttribute();
            }
            case CJK: {
                return this.mElement.getStyleLanguageAsianAttribute();
            }
            case CTL: {
                return this.mElement.getStyleLanguageComplexAttribute();
            }
        }
        return null;
    }

    public void setLanguage(String language) {
        this.setLanguage(language, Document.ScriptType.WESTERN);
    }

    public void setLanguage(String language, Document.ScriptType type) {
        if (language == null) {
            switch (type) {
                case WESTERN: {
                    this.mElement.removeAttribute(FoLanguageAttribute.ATTRIBUTE_NAME.getQName());
                    break;
                }
                case CJK: {
                    this.mElement.removeAttribute(StyleLanguageAsianAttribute.ATTRIBUTE_NAME.getQName());
                    break;
                }
                case CTL: {
                    this.mElement.removeAttribute(StyleLanguageComplexAttribute.ATTRIBUTE_NAME.getQName());
                }
            }
            return;
        }
        switch (type) {
            case WESTERN: {
                this.mElement.setFoLanguageAttribute(language);
                break;
            }
            case CJK: {
                this.mElement.setStyleLanguageAsianAttribute(language);
                break;
            }
            case CTL: {
                this.mElement.setStyleLanguageComplexAttribute(language);
            }
        }
    }

    public String getCountry() {
        return this.getCountry(Document.ScriptType.WESTERN);
    }

    public String getCountry(Document.ScriptType type) {
        switch (type) {
            case WESTERN: {
                return this.mElement.getFoCountryAttribute();
            }
            case CJK: {
                return this.mElement.getStyleCountryAsianAttribute();
            }
            case CTL: {
                return this.mElement.getStyleCountryComplexAttribute();
            }
        }
        return null;
    }

    public void setCountry(String country) {
        this.setCountry(country, Document.ScriptType.WESTERN);
    }

    public void setCountry(String country, Document.ScriptType type) {
        if (country == null) {
            switch (type) {
                case WESTERN: {
                    this.mElement.removeAttribute(FoCountryAttribute.ATTRIBUTE_NAME.getQName());
                    break;
                }
                case CJK: {
                    this.mElement.removeAttribute(StyleCountryAsianAttribute.ATTRIBUTE_NAME.getQName());
                    break;
                }
                case CTL: {
                    this.mElement.removeAttribute(StyleCountryComplexAttribute.ATTRIBUTE_NAME.getQName());
                }
            }
            return;
        }
        switch (type) {
            case WESTERN: {
                this.mElement.setFoCountryAttribute(country);
                break;
            }
            case CJK: {
                this.mElement.setStyleCountryAsianAttribute(country);
                break;
            }
            case CTL: {
                this.mElement.setStyleCountryComplexAttribute(country);
            }
        }
    }

    public Color getFontColor() {
        String color = this.mElement.getFoColorAttribute();
        if (color != null) {
            return Color.valueOf((String)this.mElement.getFoColorAttribute());
        }
        return null;
    }

    public void setFontColor(Color fontColor) {
        if (fontColor == null) {
            this.mElement.removeAttribute(FoColorAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setFoColorAttribute(fontColor.toString());
        }
    }

    public String getFontName() {
        return this.mElement.getStyleFontNameAttribute();
    }

    public String getFontName(Document.ScriptType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case WESTERN: {
                return this.mElement.getStyleFontNameAttribute();
            }
            case CJK: {
                return this.mElement.getStyleFontNameAsianAttribute();
            }
            case CTL: {
                return this.mElement.getStyleFontNameComplexAttribute();
            }
        }
        return null;
    }

    public void setFontName(String fontName) {
        this.mElement.setStyleFontNameAttribute(fontName);
    }

    public void setFontName(String fontName, Document.ScriptType type) {
        if (fontName == null) {
            switch (type) {
                case WESTERN: {
                    this.mElement.removeAttribute(StyleFontNameAttribute.ATTRIBUTE_NAME.getQName());
                    break;
                }
                case CJK: {
                    this.mElement.removeAttribute(StyleFontNameAsianAttribute.ATTRIBUTE_NAME.getQName());
                    break;
                }
                case CTL: {
                    this.mElement.removeAttribute(StyleFontNameComplexAttribute.ATTRIBUTE_NAME.getQName());
                }
            }
            return;
        }
        switch (type) {
            case WESTERN: {
                this.mElement.setStyleFontNameAttribute(fontName);
                break;
            }
            case CJK: {
                this.mElement.setStyleFontNameAsianAttribute(fontName);
                break;
            }
            case CTL: {
                this.mElement.setStyleFontNameComplexAttribute(fontName);
            }
        }
    }

    public Font getFont() {
        return this.getFont(Document.ScriptType.WESTERN);
    }

    public Font getFont(Document.ScriptType type) {
        String fontName = this.getFontName(type);
        String familyName = null;
        familyName = fontName != null ? this.getFontFamilyNameFromFontName(fontName) : this.getFontFamilyName(type);
        double size = this.getFontSizeInPoint(type);
        StyleTypeDefinitions.FontStyle fontStyle = this.getFontStyle(type);
        StyleTypeDefinitions.TextLinePosition lineStyle = this.getTextLineStyle();
        Font aFont = new Font(familyName, fontStyle, size, lineStyle);
        Color color = this.getFontColor();
        if (color != null) {
            aFont.setColor(color);
        }
        return aFont;
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        this.setFont(font, Document.ScriptType.WESTERN, null);
        if (font.getColor() != null) {
            this.setFontColor(font.getColor());
        }
    }

    public void setFont(Font font, Locale language) {
        if (font == null) {
            return;
        }
        if (language == null) {
            this.setFont(font, Document.ScriptType.WESTERN, null);
        } else {
            this.setFont(font, Document.getScriptType(language), language);
        }
        if (font.getColor() != null) {
            this.setFontColor(font.getColor());
        }
    }

    public String getFontFamilyName(Document.ScriptType type) {
        switch (type) {
            case WESTERN: {
                return this.mElement.getFoFontFamilyAttribute();
            }
            case CJK: {
                return this.mElement.getStyleFontFamilyAsianAttribute();
            }
            case CTL: {
                return this.mElement.getStyleFontFamilyComplexAttribute();
            }
        }
        return null;
    }

    private String getFontFamilyNameFromFontName(String aFontName) {
        try {
            Document mDocument = (Document)((OdfFileDom)this.mElement.getOwnerDocument()).getDocument();
            OdfContentDom contentDom = mDocument.getContentDom();
            OfficeFontFaceDeclsElement fontfaceDecls = (OfficeFontFaceDeclsElement)OdfElement.findFirstChildNode(OfficeFontFaceDeclsElement.class, (Node)contentDom.getRootElement());
            if (fontfaceDecls == null) {
                OdfStylesDom styleDom = mDocument.getStylesDom();
                fontfaceDecls = (OfficeFontFaceDeclsElement)OdfElement.findFirstChildNode(OfficeFontFaceDeclsElement.class, (Node)styleDom.getRootElement());
            }
            if (fontfaceDecls == null) {
                return null;
            }
            NodeList list = fontfaceDecls.getElementsByTagName("style:font-face");
            for (int i = 0; i < list.getLength(); ++i) {
                StyleFontFaceElement node = (StyleFontFaceElement)list.item(i);
                String familyname = node.getSvgFontFamilyAttribute();
                String fontName = node.getStyleNameAttribute();
                if (!aFontName.equals(fontName)) continue;
                return familyname;
            }
        }
        catch (Exception e) {
            Logger.getLogger(TextProperties.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    private String getFontNameFromFamilyName(String aFamilyName) {
        String aFontName = aFamilyName;
        boolean duplicated = false;
        try {
            StyleFontFaceElement node;
            int i;
            OdfStylesDom styleDom;
            Document mDocument = (Document)((OdfFileDom)this.mElement.getOwnerDocument()).getDocument();
            OdfContentDom contentDom = mDocument.getContentDom();
            OfficeFontFaceDeclsElement fontfaceDecls = (OfficeFontFaceDeclsElement)OdfElement.findFirstChildNode(OfficeFontFaceDeclsElement.class, (Node)contentDom.getRootElement());
            if (fontfaceDecls == null && (fontfaceDecls = (OfficeFontFaceDeclsElement)OdfElement.findFirstChildNode(OfficeFontFaceDeclsElement.class, (Node)(styleDom = mDocument.getStylesDom()).getRootElement())) == null) {
                fontfaceDecls = contentDom.getRootElement().newOfficeFontFaceDeclsElement();
            }
            NodeList list = fontfaceDecls.getElementsByTagName("style:font-face");
            for (i = 0; i < list.getLength(); ++i) {
                node = (StyleFontFaceElement)list.item(i);
                String familyname = node.getSvgFontFamilyAttribute();
                String fontName = node.getStyleNameAttribute();
                if (aFamilyName.equals(familyname)) {
                    return fontName;
                }
                if (!aFontName.equals(fontName)) continue;
                duplicated = true;
            }
            block3: while (duplicated) {
                duplicated = false;
                aFontName = aFontName + "_1";
                for (i = 0; i < list.getLength(); ++i) {
                    node = (StyleFontFaceElement)list.item(i);
                    String fontName = node.getStyleNameAttribute();
                    if (!aFontName.equals(fontName)) continue;
                    duplicated = true;
                    continue block3;
                }
            }
            StyleFontFaceElement newfont = fontfaceDecls.newStyleFontFaceElement(aFontName);
            newfont.setSvgFontFamilyAttribute(aFamilyName);
            return aFontName;
        }
        catch (Exception e) {
            Logger.getLogger(TextProperties.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private void setFont(Font font, Document.ScriptType type, Locale locale) {
        String fontName = this.getFontNameFromFamilyName(font.getFamilyName());
        if (fontName == null) {
            return;
        }
        font.setFontName(fontName);
        switch (type) {
            case WESTERN: {
                this.setFontName(font.getFontName(), Document.ScriptType.WESTERN);
                this.setFontStyle(font.getFontStyle(), Document.ScriptType.WESTERN);
                this.setFontSizeInPoint(font.getSize(), Document.ScriptType.WESTERN);
                if (locale == null) break;
                this.setLanguage(locale.getLanguage(), Document.ScriptType.WESTERN);
                this.setCountry(locale.getCountry(), Document.ScriptType.WESTERN);
                break;
            }
            case CJK: {
                this.setFontName(font.getFontName(), Document.ScriptType.CJK);
                this.setFontStyle(font.getFontStyle(), Document.ScriptType.CJK);
                this.setFontSizeInPoint(font.getSize(), Document.ScriptType.CJK);
                if (locale == null) break;
                this.setLanguage(locale.getLanguage(), Document.ScriptType.CJK);
                this.setCountry(locale.getCountry(), Document.ScriptType.CJK);
                break;
            }
            case CTL: {
                this.setFontName(font.getFontName(), Document.ScriptType.CTL);
                this.setFontStyle(font.getFontStyle(), Document.ScriptType.CTL);
                this.setFontSizeInPoint(font.getSize(), Document.ScriptType.CTL);
                if (locale == null) break;
                this.setLanguage(locale.getLanguage(), Document.ScriptType.CTL);
                this.setCountry(locale.getCountry(), Document.ScriptType.CTL);
            }
        }
        this.setTextLineStyle(font.getTextLinePosition());
    }

    public static TextProperties getOrCreateTextProperties(OdfStyleBase style) {
        OdfStylePropertiesBase properties = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.TextProperties);
        return new TextProperties((StyleTextPropertiesElement)properties);
    }

    public static TextProperties getTextProperties(OdfStyleBase style) {
        OdfStylePropertiesBase properties = style.getPropertiesElement(OdfStylePropertiesSet.TextProperties);
        if (properties != null) {
            return new TextProperties((StyleTextPropertiesElement)properties);
        }
        return null;
    }
}

