/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.valueeditors;

import org.apache.directory.studio.aciitemeditor.valueeditors.Messages;
import org.apache.directory.studio.ldapbrowser.common.dialogs.FilterWidgetDialog;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.eclipse.swt.widgets.Shell;

public class FilterValueEditor
extends AbstractDialogStringValueEditor {
    private static final String EMPTY = "";

    public boolean openDialog(Shell shell) {
        Object value = this.getValue();
        if (value instanceof FilterValueEditorRawValueWrapper) {
            FilterValueEditorRawValueWrapper wrapper = (FilterValueEditorRawValueWrapper)value;
            FilterWidgetDialog dialog = new FilterWidgetDialog(shell, Messages.getString("FilterValueEditor.dialog.title"), wrapper.filter, wrapper.connection);
            if (dialog.open() == 0 && !EMPTY.equals(dialog.getFilter())) {
                this.setValue(dialog.getFilter());
                return true;
            }
        }
        return false;
    }

    public Object getRawValue(IValue value) {
        if (value != null) {
            return this.getRawValue(value.getAttribute().getEntry().getBrowserConnection(), value.getStringValue());
        }
        return null;
    }

    private Object getRawValue(IBrowserConnection connection, Object value) {
        if (connection == null || !(value instanceof String)) {
            return null;
        }
        String filterValue = (String)value;
        FilterValueEditorRawValueWrapper wrapper = new FilterValueEditorRawValueWrapper(connection, filterValue);
        return wrapper;
    }

    private class FilterValueEditorRawValueWrapper {
        private IBrowserConnection connection;
        private String filter;

        private FilterValueEditorRawValueWrapper(IBrowserConnection connection, String filter) {
            this.connection = connection;
            this.filter = filter;
        }
    }
}

