/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.wizards;

import java.util.Collection;
import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetActionGroup;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetActionGroupWithAttribute;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetConfiguration;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetUniversalListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.OpenDefaultEditorAction;
import org.apache.directory.studio.ldapbrowser.common.wizards.Messages;
import org.apache.directory.studio.ldapbrowser.common.wizards.NewEntryWizard;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Attribute;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyEntry;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public class NewEntryAttributesWizardPage
extends WizardPage
implements EntryUpdateListener {
    private NewEntryWizard wizard;
    private EntryEditorWidgetConfiguration configuration;
    private EntryEditorWidgetActionGroup actionGroup;
    private EntryEditorWidget mainWidget;
    private EntryEditorWidgetUniversalListener universalListener;
    private IContextActivation contextActivation;

    public NewEntryAttributesWizardPage(String pageName, NewEntryWizard wizard) {
        super(pageName);
        this.setTitle(Messages.getString("NewEntryAttributesWizardPage.Attributes"));
        this.setDescription(Messages.getString("NewEntryAttributesWizardPage.PleaseEnterAttributesForEntry"));
        this.setImageDescriptor(BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/entry_wizard.gif"));
        this.setPageComplete(false);
        this.wizard = wizard;
        IWizardContainer container = wizard.getContainer();
        if (container instanceof WizardDialog) {
            WizardDialog dialog = (WizardDialog)container;
            dialog.addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    if (NewEntryAttributesWizardPage.this.getControl().isVisible()) {
                        IAttribute[] iAttributeArray = NewEntryAttributesWizardPage.this.wizard.getPrototypeEntry().getAttributes();
                        int n = iAttributeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IAttribute attribute = iAttributeArray[n2];
                            IValue[] iValueArray = attribute.getValues();
                            int n3 = iValueArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IValue value = iValueArray[n4];
                                if (value.isEmpty()) {
                                    NewEntryAttributesWizardPage.this.mainWidget.getViewer().setSelection((ISelection)new StructuredSelection((Object)value), true);
                                    OpenDefaultEditorAction openDefaultEditorAction = NewEntryAttributesWizardPage.this.actionGroup.getOpenDefaultEditorAction();
                                    if (openDefaultEditorAction.isEnabled()) {
                                        openDefaultEditorAction.run();
                                    }
                                    return;
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                }
            });
        }
    }

    public void dispose() {
        if (this.configuration != null) {
            EventRegistry.removeEntryUpdateListener((EntryUpdateListener)this);
            this.universalListener.dispose();
            this.universalListener = null;
            this.mainWidget.dispose();
            this.mainWidget = null;
            this.actionGroup.dispose();
            this.actionGroup = null;
            this.configuration.dispose();
            this.configuration = null;
            if (this.contextActivation != null) {
                IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
                contextService.deactivateContext(this.contextActivation);
                this.contextActivation = null;
            }
        }
        super.dispose();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            DummyEntry newEntry = this.wizard.getPrototypeEntry();
            try {
                EventRegistry.suspendEventFiringInCurrentThread();
                Collection oldMusts = SchemaUtils.getMustAttributeTypeDescriptions((IEntry)newEntry);
                for (AttributeType oldMust : oldMusts) {
                    IAttribute attribute = newEntry.getAttribute(oldMust.getOid());
                    if (attribute == null) continue;
                    IValue[] values = attribute.getValues();
                    int v = 0;
                    while (v < values.length) {
                        if (values[v].isEmpty()) {
                            attribute.deleteValue(values[v]);
                        }
                        ++v;
                    }
                    if (attribute.getValueSize() != 0) continue;
                    newEntry.deleteAttribute(attribute);
                }
                Collection newMusts = SchemaUtils.getMustAttributeTypeDescriptions((IEntry)newEntry);
                for (AttributeType newMust : newMusts) {
                    if (newEntry.getAttributeWithSubtypes(newMust.getOid()) != null) continue;
                    String friendlyIdentifier = SchemaUtils.getFriendlyIdentifier((AbstractSchemaObject)newMust);
                    Attribute att = new Attribute((IEntry)newEntry, friendlyIdentifier);
                    newEntry.addAttribute((IAttribute)att);
                    att.addEmptyValue();
                }
            }
            finally {
                EventRegistry.resumeEventFiringInCurrentThread();
            }
            this.universalListener.setInput((IEntry)newEntry);
            this.mainWidget.getViewer().refresh();
            this.validate();
            this.mainWidget.getViewer().getControl().setFocus();
        } else {
            this.mainWidget.getViewer().setInput((Object)"");
            this.mainWidget.getViewer().refresh();
            this.setPageComplete(false);
        }
    }

    private void validate() {
        if (this.wizard.getPrototypeEntry() != null) {
            Collection messages = SchemaUtils.getEntryIncompleteMessages((IEntry)this.wizard.getPrototypeEntry());
            if (messages != null && !messages.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                for (String message : messages) {
                    sb.append(message);
                    sb.append(' ');
                }
                this.setMessage(sb.toString(), 2);
            } else {
                this.setMessage(null);
            }
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        this.configuration = new EntryEditorWidgetConfiguration();
        this.mainWidget = new EntryEditorWidget(this.configuration);
        this.mainWidget.createWidget(composite);
        this.mainWidget.getViewer().getTree().setFocus();
        this.actionGroup = new EntryEditorWidgetActionGroupWithAttribute(this.mainWidget, this.configuration);
        this.actionGroup.fillToolBar(this.mainWidget.getToolBarManager());
        this.actionGroup.fillMenu(this.mainWidget.getMenuManager());
        this.actionGroup.fillContextMenu(this.mainWidget.getContextMenuManager());
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
        this.contextActivation = contextService.activateContext(BrowserCommonConstants.CONTEXT_DIALOGS);
        this.actionGroup.activateGlobalActionHandlers();
        this.universalListener = new EntryEditorWidgetUniversalListener(this.mainWidget.getViewer(), this.configuration, this.actionGroup, this.actionGroup.getOpenDefaultEditorAction());
        EventRegistry.addEntryUpdateListener((EntryUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
        this.setControl((Control)composite);
    }

    public void entryUpdated(EntryModificationEvent event) {
        if (event.getModifiedEntry() == this.wizard.getPrototypeEntry() && !this.isDisposed() && this.getControl().isVisible()) {
            this.validate();
        }
    }

    private boolean isDisposed() {
        return this.configuration == null;
    }
}

