/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.common.ui;

import org.apache.directory.studio.common.ui.Messages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.framework.Bundle;

public class CommonUIUtils {
    public static void openErrorDialog(String message) {
        CommonUIUtils.openErrorDialog(Messages.getString("CommonUIUtils.Error"), message);
    }

    public static void openErrorDialog(String title, String message) {
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    public static void openInformationDialog(String message) {
        CommonUIUtils.openInformationDialog(Messages.getString("CommonUIUtils.Information"), message);
    }

    public static void openInformationDialog(String title, String message) {
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    public static void openWarningDialog(String message) {
        CommonUIUtils.openWarningDialog(Messages.getString("CommonUIUtils.Warning"), message);
    }

    public static void openWarningDialog(String title, String message) {
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, message, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    public static boolean isIDEEnvironment() {
        Bundle bundle = Platform.getBundle((String)"org.apache.directory.studio.rcp");
        return bundle == null;
    }

    public static Text createText(FormToolkit toolkit, Composite composite, String label, String defaultValue, int limit, ModifyListener listener) {
        toolkit.createLabel(composite, label);
        String value = "";
        if (defaultValue != null) {
            value = defaultValue;
        }
        Text text = toolkit.createText(composite, value);
        text.setLayoutData((Object)new GridData(4, 0, true, false));
        if (limit >= 0) {
            text.setTextLimit(limit);
        }
        if (listener != null) {
            text.addModifyListener(listener);
        }
        return text;
    }

    public static Text createText(FormToolkit toolkit, Composite composite, String label, String defaultValue, int limit, GridData gridData, ModifyListener listener) {
        toolkit.createLabel(composite, label);
        String value = "";
        if (defaultValue != null) {
            value = defaultValue;
        }
        Text text = toolkit.createText(composite, value);
        text.setLayoutData((Object)gridData);
        if (limit >= 0) {
            text.setTextLimit(limit);
        }
        if (listener != null) {
            text.addModifyListener(listener);
        }
        return text;
    }

    public static String getTextValue(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static String getTextValue(int value) {
        if (value == 0) {
            return "";
        }
        return Integer.toString(value);
    }
}

