/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.BulkModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.ImportLdifRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldifparser.model.LdifEnumeration;
import org.apache.directory.studio.ldifparser.parser.LdifParser;

public class ExecuteLdifRunnable
implements StudioConnectionBulkRunnableWithProgress {
    private IBrowserConnection browserConnection;
    private String ldif;
    private boolean updateIfEntryExists;
    private boolean continueOnError;

    public ExecuteLdifRunnable(IBrowserConnection browserConnection, String ldif, boolean updateIfEntryExists, boolean continueOnError) {
        this.browserConnection = browserConnection;
        this.ldif = ldif;
        this.continueOnError = continueOnError;
        this.updateIfEntryExists = updateIfEntryExists;
    }

    public Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    public String getName() {
        return BrowserCoreMessages.jobs__execute_ldif_name;
    }

    public Object[] getLockedObjects() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.browserConnection.getUrl() + "_" + DigestUtils.shaHex((String)this.ldif));
        return l.toArray();
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__execute_ldif_error;
    }

    public void run(StudioProgressMonitor monitor) {
        ExecuteLdifRunnable.executeLdif(this.browserConnection, this.ldif, this.updateIfEntryExists, this.continueOnError, monitor);
    }

    public static void executeLdif(IBrowserConnection browserConnection, String ldif, boolean updateIfEntryExists, boolean continueOnError, StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.jobs__execute_ldif_task, 2);
        monitor.reportProgress(" ");
        monitor.worked(1);
        try {
            StringReader ldifReader = new StringReader(ldif);
            LdifParser parser = new LdifParser();
            LdifEnumeration enumeration = parser.parse((Reader)ldifReader);
            Writer logWriter = new Writer(){

                @Override
                public void close() {
                }

                @Override
                public void flush() {
                }

                @Override
                public void write(char[] cbuf, int off, int len) {
                }
            };
            ImportLdifRunnable.importLdif(browserConnection, enumeration, logWriter, updateIfEntryExists, continueOnError, monitor);
            logWriter.close();
            ((Reader)ldifReader).close();
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }

    public void runNotification(StudioProgressMonitor monitor) {
        EventRegistry.fireEntryUpdated(new BulkModificationEvent(this.browserConnection), this);
    }
}

