/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.widget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.model.difference.SchemaDifference;
import org.apache.directory.studio.schemaeditor.view.widget.FirstNameSorter;
import org.apache.directory.studio.schemaeditor.view.widget.Folder;
import org.apache.directory.studio.schemaeditor.view.widget.OidSorter;
import org.apache.directory.studio.schemaeditor.view.widget.SchemaDifferenceSorter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DifferencesWidgetSchemaContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private FirstNameSorter firstNameSorter = new FirstNameSorter();
    private OidSorter oidSorter = new OidSorter();
    private SchemaDifferenceSorter schemaDifferenceSorter = new SchemaDifferenceSorter();

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> children = new ArrayList<Object>();
        int group = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING);
        int sortBy = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SORTING_BY);
        int sortOrder = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SORTING_ORDER);
        if (parentElement instanceof List) {
            List schemaDifferences = (List)parentElement;
            children.addAll(schemaDifferences);
            Collections.sort(children, this.schemaDifferenceSorter);
        } else if (parentElement instanceof SchemaDifference) {
            SchemaDifference difference = (SchemaDifference)parentElement;
            if (group == 0) {
                Folder atFolder = new Folder(Folder.FolderType.ATTRIBUTE_TYPE);
                atFolder.addAllChildren(difference.getAttributeTypesDifferences());
                children.add(atFolder);
                Folder ocFolder = new Folder(Folder.FolderType.OBJECT_CLASS);
                ocFolder.addAllChildren(difference.getObjectClassesDifferences());
                children.add(ocFolder);
            } else if (group == 1) {
                children.addAll(difference.getAttributeTypesDifferences());
                children.addAll(difference.getObjectClassesDifferences());
                if (sortBy == 0) {
                    Collections.sort(children, this.firstNameSorter);
                } else if (sortBy == 1) {
                    Collections.sort(children, this.oidSorter);
                }
                if (sortOrder == 1) {
                    Collections.reverse(children);
                }
            }
        } else if (parentElement instanceof Folder) {
            children.addAll(((Folder)parentElement).getChildren());
            if (sortBy == 0) {
                Collections.sort(children, this.firstNameSorter);
            } else if (sortBy == 1) {
                Collections.sort(children, this.oidSorter);
            }
            if (sortOrder == 1) {
                Collections.reverse(children);
            }
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof SchemaDifference) {
            return true;
        }
        return element instanceof Folder;
    }
}

