/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.schemaeditor.view.editors.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class EditorsUtils {
    public static boolean saveAllDirtyEditors() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        List<IEditorPart> dirtyEditorsList = EditorsUtils.getDirtyEditorsList(workbench);
        if (dirtyEditorsList.size() > 0) {
            ListDialog dialog = new ListDialog(workbenchWindow.getShell());
            dialog.setTitle(Messages.getString("EditorsUtils.SaveDialogTitle"));
            dialog.setMessage(Messages.getString("EditorsUtils.SaveDialogMessage"));
            dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    return ((IEditorPart)element).getTitleImage();
                }

                public String getText(Object element) {
                    IEditorPart editorPart = (IEditorPart)element;
                    StringBuilder sb = new StringBuilder();
                    sb.append(editorPart.getTitle());
                    String tooltip = editorPart.getTitleToolTip();
                    if (tooltip != null && !"".equals(tooltip)) {
                        sb.append(" [");
                        sb.append(tooltip);
                        sb.append("]");
                    }
                    return sb.toString();
                }
            });
            dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            dialog.setHelpAvailable(false);
            dialog.setAddCancelButton(true);
            dialog.setInput(dirtyEditorsList);
            if (dialog.open() != 0) {
                return false;
            }
            return workbenchWindow.getWorkbench().saveAllEditors(false);
        }
        return true;
    }

    public static List<IEditorPart> getDirtyEditorsList(IWorkbench workbench) {
        ArrayList<IEditorPart> dirtyEditorsList = new ArrayList<IEditorPart>();
        if (workbench != null) {
            ArrayList<IEditorInput> processedInputs = new ArrayList<IEditorInput>();
            IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = workbenchWindow.getPages();
                int n3 = iWorkbenchPageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage workbenchPage = iWorkbenchPageArray[n4];
                    IEditorPart[] iEditorPartArray = workbenchPage.getDirtyEditors();
                    int n5 = iEditorPartArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IEditorPart editor = iEditorPartArray[n6];
                        IEditorInput input = editor.getEditorInput();
                        if (!processedInputs.contains(input)) {
                            processedInputs.add(input);
                            dirtyEditorsList.add(editor);
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return dirtyEditorsList;
    }
}

