/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.realm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.directory.fortress.core.AccessMgr;
import org.apache.directory.fortress.core.AccessMgrFactory;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.ReviewMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.util.VUtil;
import org.apache.directory.fortress.realm.J2eePolicyMgr;
import org.apache.directory.fortress.realm.TcPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class J2eePolicyMgrImpl
implements J2eePolicyMgr {
    private static final String CLS_NM = J2eePolicyMgrImpl.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private AccessMgr accessMgr;
    private ReviewMgr reviewMgr;
    private static final String SESSION = "session";
    private String contextId;

    J2eePolicyMgrImpl() {
        try {
            this.accessMgr = AccessMgrFactory.createInstance();
            this.reviewMgr = ReviewMgrFactory.createInstance();
            LOG.info("{} - constructed", (Object)CLS_NM);
        }
        catch (SecurityException se) {
            LOG.error("{} caught SecurityException={}", (Object)CLS_NM, (Object)se);
        }
    }

    @Override
    public boolean authenticate(String userId, String password) throws SecurityException {
        boolean result = false;
        Session session = this.accessMgr.authenticate(userId, password);
        if (session != null) {
            result = true;
            LOG.debug("{}.authenticate userId [{}], successful", (Object)CLS_NM, (Object)userId);
        } else {
            LOG.debug("{}.authenticate userId [{}], failed", (Object)CLS_NM, (Object)userId);
        }
        return result;
    }

    @Override
    public TcPrincipal createSession(String userId, String password) throws SecurityException {
        User user = new User(userId, new String(password));
        return this.createSession(user);
    }

    @Override
    public TcPrincipal createSession(String userId, String password, List<String> roles) throws SecurityException {
        User user = new User(userId, new String(password));
        if (CollectionUtils.isNotEmpty(roles)) {
            for (String role : roles) {
                user.setRoleName(role);
            }
        }
        return this.createSession(user);
    }

    private TcPrincipal createSession(User user) throws SecurityException {
        Session session = this.accessMgr.createSession(user, false);
        LOG.debug("{}.createSession userId [{}], successful", (Object)CLS_NM, (Object)user.getUserId());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(SESSION, session);
        String ser = this.serialize(session);
        context.put("SERIALIZED", ser);
        return new TcPrincipal(user.getUserId(), context);
    }

    @Override
    public Session createSession(User user, boolean isTrusted) throws SecurityException {
        LOG.debug("{}.createSession userId [{}], isTrusted [{}]", new Object[]{CLS_NM, user.getUserId(), isTrusted});
        return this.accessMgr.createSession(user, isTrusted);
    }

    @Override
    public boolean hasRole(Principal principal, String roleName) throws SecurityException {
        String fullMethodName = CLS_NM + ".hasRole";
        LOG.debug("{}.hasRole userId [{}], role [{}]", new Object[]{CLS_NM, principal.getName(), roleName});
        boolean result = false;
        HashMap<String, Object> context = ((TcPrincipal)principal).getContext();
        VUtil.assertNotNull(context, (int)1036, (String)fullMethodName);
        Session session = (Session)context.get(SESSION);
        VUtil.assertNotNull((Object)session, (int)1030, (String)fullMethodName);
        Set authZRoles = this.accessMgr.authorizedRoles(session);
        if (authZRoles != null && authZRoles.size() > 0) {
            if (authZRoles.contains(roleName)) {
                LOG.debug("{} userId [{}], role [{}], successful", new Object[]{fullMethodName, principal.getName(), roleName});
                result = true;
            } else {
                LOG.debug("{} userId [{}], is not authorized role [{}]", new Object[]{fullMethodName, principal.getName(), roleName});
            }
        } else {
            LOG.info("{} userId [{}], role [{}], has no authorized roles", new Object[]{fullMethodName, principal.getName(), roleName});
        }
        return result;
    }

    @Override
    public Role readRole(String roleName) throws SecurityException {
        return this.reviewMgr.readRole(new Role(roleName));
    }

    @Override
    public List<String> searchRoles(String searchString, int limit) throws SecurityException {
        return this.reviewMgr.findRoles(searchString, limit);
    }

    @Override
    public User readUser(String userId) throws SecurityException {
        return this.reviewMgr.readUser(new User(userId));
    }

    @Override
    public List<String> searchUsers(String searchString, int limit) throws SecurityException {
        return this.reviewMgr.findUsers(new User(searchString), limit);
    }

    @Override
    public List<String> assignedUsers(String roleName, int limit) throws SecurityException {
        return this.reviewMgr.assignedUsers(new Role(roleName), limit);
    }

    @Override
    public List<String> authorizedRoles(String userId) throws SecurityException {
        ArrayList list = null;
        Session session = this.createSession(new User(userId), true);
        Set authZRoleSet = this.accessMgr.authorizedRoles(session);
        if (authZRoleSet != null && authZRoleSet.size() > 0) {
            list = new ArrayList(authZRoleSet);
        }
        return list;
    }

    private String serialize(Object obj) throws SecurityException {
        String szRetVal = null;
        if (obj != null) {
            try {
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                ObjectOutputStream so = new ObjectOutputStream(bo);
                so.writeObject(obj);
                so.flush();
                szRetVal = bo.toString("ISO-8859-1");
            }
            catch (IOException ioe) {
                String error = "serialize caught IOException: " + ioe;
                throw new SecurityException(201, error, (Exception)ioe);
            }
        }
        return szRetVal;
    }

    @Override
    public Session deserialize(String str) throws SecurityException {
        try {
            byte[] b = str.getBytes("ISO-8859-1");
            ByteArrayInputStream bi = new ByteArrayInputStream(b);
            ObjectInputStream si = new ObjectInputStream(bi);
            return (Session)Session.class.cast(si.readObject());
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(203, "deserialize caught UnsupportedEncodingException:" + e, (Exception)e);
        }
        catch (IOException e) {
            LOG.warn("deserialize caught IOException:" + e);
            throw new SecurityException(202, "deserialize caught IOException:" + e, (Exception)e);
        }
        catch (ClassNotFoundException e) {
            LOG.warn("deserialize caught ClassNotFoundException:" + e);
            throw new SecurityException(204, "deserialize caught ClassNotFoundException:" + e, (Exception)e);
        }
    }

    @Override
    public final void setContextId(String contextId) {
        this.contextId = contextId;
        this.accessMgr.setContextId(contextId);
        this.reviewMgr.setContextId(contextId);
    }
}

