/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.scope.window.strategy;

import java.io.IOException;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Typed;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.deltaspike.jsf.impl.scope.window.strategy.AbstractClientWindowStrategy;
import org.apache.deltaspike.jsf.impl.util.ClientWindowHelper;
import org.apache.deltaspike.jsf.impl.util.JsfUtils;
import org.owasp.encoder.Encode;

@Dependent
@Typed(value={ClientSideWindowStrategy.class})
public class ClientSideWindowStrategy
extends AbstractClientWindowStrategy {
    private static final String AUTOMATED_ENTRY_POINT_PARAMETER_KEY = "automatedEntryPoint";
    private static final String UNINITIALIZED_WINDOW_ID_VALUE = "uninitializedWindowId";
    private static final String WINDOW_ID_REPLACE_PATTERN = "$$windowIdValue$$";
    private static final String REQUEST_URL_REPLACE_PATTERN = "$$requestUrl$$";
    private static final String NOSCRIPT_URL_REPLACE_PATTERN = "$$noscriptUrl$$";
    private static final String NOSCRIPT_PARAMETER = "mfDirect";

    @Override
    protected String getOrCreateWindowId(FacesContext facesContext) {
        String windowId = null;
        boolean post = this.isPost(facesContext);
        if (post) {
            windowId = this.getWindowIdPostParameter(facesContext);
        } else if (this.isNoscriptRequest(facesContext.getExternalContext())) {
            this.clientWindowConfig.setJavaScriptEnabled(false);
            windowId = "default";
        } else {
            windowId = this.getVerifiedWindowIdFromCookie(facesContext.getExternalContext());
            boolean newWindowIdRequested = false;
            if (AUTOMATED_ENTRY_POINT_PARAMETER_KEY.equals(windowId)) {
                windowId = this.generateNewWindowId();
                newWindowIdRequested = true;
            }
            if (windowId == null || newWindowIdRequested) {
                this.sendWindowHandlerHtml(facesContext.getExternalContext(), windowId);
                facesContext.responseComplete();
            }
        }
        return windowId;
    }

    protected boolean isNoscriptRequest(ExternalContext externalContext) {
        String noscript = (String)externalContext.getRequestParameterMap().get(NOSCRIPT_PARAMETER);
        return noscript != null && "true".equals(noscript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendWindowHandlerHtml(ExternalContext externalContext, String windowId) {
        HttpServletResponse httpResponse = (HttpServletResponse)externalContext.getResponse();
        try {
            httpResponse.setStatus(200);
            httpResponse.setContentType("text/html");
            String windowHandlerHtml = this.clientWindowConfig.getClientWindowHtml();
            if (windowId == null) {
                windowId = UNINITIALIZED_WINDOW_ID_VALUE;
            }
            windowHandlerHtml = windowHandlerHtml.replace(WINDOW_ID_REPLACE_PATTERN, Encode.forJavaScriptBlock((String)windowId));
            windowHandlerHtml = windowHandlerHtml.replace(REQUEST_URL_REPLACE_PATTERN, Encode.forJavaScriptBlock((String)ClientWindowHelper.constructRequestUrl(externalContext)));
            windowHandlerHtml = windowHandlerHtml.replace(NOSCRIPT_URL_REPLACE_PATTERN, Encode.forHtmlAttribute((String)this.getNoscriptUrl(externalContext)));
            try (ServletOutputStream os = httpResponse.getOutputStream();){
                os.write(windowHandlerHtml.getBytes());
            }
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }

    protected String getNoscriptUrl(ExternalContext externalContext) {
        int lastSlash;
        String url = externalContext.getRequestPathInfo();
        if (url == null) {
            url = "";
        }
        if ((lastSlash = url.lastIndexOf(47)) != -1) {
            url = url.substring(lastSlash + 1);
        }
        url = JsfUtils.addPageParameters(externalContext, url, true);
        url = JsfUtils.addParameter(externalContext, url, false, NOSCRIPT_PARAMETER, "true");
        url = url.replace("\"", "");
        url = url.replace("'", "");
        return url;
    }

    protected String getVerifiedWindowIdFromCookie(ExternalContext externalContext) {
        String cookieName = "dsrwid-" + this.getRequestTokenParameter(externalContext);
        Cookie cookie = (Cookie)externalContext.getRequestCookieMap().get(cookieName);
        if (cookie != null) {
            cookie.setMaxAge(0);
            return cookie.getValue();
        }
        return null;
    }

    protected String getRequestTokenParameter(ExternalContext externalContext) {
        String requestToken = (String)externalContext.getRequestParameterMap().get("dsrid");
        if (requestToken != null) {
            return requestToken;
        }
        return "";
    }

    @Override
    public String interceptRedirect(FacesContext facesContext, String url) {
        boolean get;
        boolean ajax = facesContext.getPartialViewContext().isAjaxRequest();
        boolean post = this.isPost(facesContext);
        boolean bl = get = !post;
        if (!ajax && get || ajax && post) {
            String requestToken = this.generateNewRequestToken();
            String windowId = this.getWindowId(facesContext);
            ClientWindowHelper.addRequestWindowIdCookie(facesContext, requestToken, windowId);
            url = JsfUtils.addParameter(facesContext.getExternalContext(), url, true, "dswid", windowId);
            url = JsfUtils.addParameter(facesContext.getExternalContext(), url, true, "dsrid", requestToken);
            return url;
        }
        return url;
    }
}

