/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.testcontrol.impl.mock;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.testcontrol.api.mock.DynamicMockManager;

public class MockAwareProducerWrapper<T>
implements Producer<T> {
    private final BeanManager beanManager;
    private final Producer<T> wrapped;
    private final List<Type> beanTypes;
    private final List<Annotation> qualifiers;

    public MockAwareProducerWrapper(BeanManager beanManager, Producer<T> wrapped, List<Type> beanTypes, List<Annotation> qualifiers) {
        this.beanManager = beanManager;
        this.wrapped = wrapped;
        this.beanTypes = beanTypes;
        this.qualifiers = qualifiers;
    }

    public T produce(CreationalContext<T> creationalContext) {
        DynamicMockManager mockManager = (DynamicMockManager)BeanProvider.getContextualReference((BeanManager)this.beanManager, DynamicMockManager.class, (boolean)false, (Annotation[])new Annotation[0]);
        for (Type beanType : this.beanTypes) {
            Object mockInstance = mockManager.getMock((Class)beanType, this.qualifiers.toArray(new Annotation[this.qualifiers.size()]));
            if (mockInstance == null) continue;
            return (T)mockInstance;
        }
        return (T)this.wrapped.produce(creationalContext);
    }

    public void dispose(T instance) {
        this.wrapped.dispose(instance);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.wrapped.getInjectionPoints();
    }
}

