/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.merge;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.torque.generator.GeneratorException;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.merge.MergeAlgorithm;
import org.eclipse.jgit.merge.MergeFormatter;
import org.eclipse.jgit.merge.MergeResult;

public class ThreeWayMerger {
    public String merge(String base, String generated, String edited, Charset charSet) throws GeneratorException {
        MergeAlgorithm mergeAlgorithm = new MergeAlgorithm();
        MergeResult mergeResult = mergeAlgorithm.merge((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)new RawText(base.getBytes(charSet)), (Sequence)new RawText(generated.getBytes(charSet)), (Sequence)new RawText(edited.getBytes(charSet)));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            new MergeFormatter().formatMerge((OutputStream)outputStream, mergeResult, "base", "generated", "edited", charSet);
        }
        catch (IOException e) {
            throw new GeneratorException("could nor render merge result", e);
        }
        return new String(outputStream.toByteArray(), charSet);
    }
}

