/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.typemapping;

public enum JavaType {
    STRING("String", false, false, null),
    BIG_DECIMAL("BigDecimal", false, true, "java.math."),
    BOOLEAN_PRIMITIVE("boolean", true, false, null),
    BOOLEAN_OBJECT("Boolean", false, false, null),
    BYTE_PRIMITIVE("byte", true, true, null),
    BYTE_OBJECT("Byte", false, true, null),
    SHORT_PRIMITIVE("short", true, true, null),
    SHORT_OBJECT("Short", false, true, null),
    INTEGER_PRIMITIVE("int", true, true, null),
    INTEGER_OBJECT("Integer", false, true, null),
    LONG_PRIMITIVE("long", true, true, null),
    LONG_OBJECT("Long", false, true, null),
    FLOAT_PRIMITIVE("float", true, true, null),
    FLOAT_OBJECT("Float", false, true, null),
    DOUBLE_PRIMITIVE("double", true, true, null),
    DOUBLE_OBJECT("Double", false, true, null),
    CHAR_PRIMITIVE("char", true, false, null),
    CHAR_OBJECT("Char", false, false, null),
    BYTE_PRIMITIVE_ARRAY("byte[]", false, false, null),
    DATE("Date", false, false, "java.util."),
    ENUM("Enum", false, false, null);

    private final String className;
    private final boolean primitive;
    private final boolean number;
    private final String packagePrefix;

    private JavaType(String className, boolean primitive, boolean number, String packagePrefix) {
        this.className = className;
        this.primitive = primitive;
        this.number = number;
        this.packagePrefix = packagePrefix;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isNumber() {
        return this.number;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    public String getFullClassName() {
        if (this.packagePrefix == null) {
            return this.className;
        }
        return this.packagePrefix + this.className;
    }
}

