/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.controller.Loglevel;
import org.apache.torque.generator.configuration.controller.Output;
import org.apache.torque.generator.configuration.outlet.OutletConfiguration;
import org.apache.torque.generator.configuration.source.EntityReferences;
import org.apache.torque.generator.option.Options;
import org.apache.torque.generator.source.SourceProvider;

public class UnitConfiguration {
    private List<Output> outputList = new ArrayList<Output>();
    private Options options;
    private SourceProvider overrideSourceProvider;
    private boolean overrideSourceProviderInitialized = false;
    private OutletConfiguration outletConfiguration;
    private EntityReferences entityReferences;
    private ConfigurationHandlers configurationHandlers;
    private final Map<String, File> outputDirectoryMap = new HashMap<String, File>();
    private File workDirectory;
    private File cacheDirectory;
    private Loglevel loglevel = Loglevel.INFO;
    private boolean addDebuggingInfoToOutput = false;
    private String defaultOutputEncoding = null;
    private ClassLoader classLoader;
    private boolean runOnlyOnSourceChange = false;
    private String templateSetName;

    public OutletConfiguration getOutletConfiguration() {
        if (this.outletConfiguration == null) {
            throw new IllegalStateException("outletConfiguration is not initialized");
        }
        return this.outletConfiguration;
    }

    public void setOutletConfiguration(OutletConfiguration outletConfiguration) {
        if (outletConfiguration == null) {
            throw new NullPointerException("outletConfiguration cannot be null");
        }
        this.outletConfiguration = outletConfiguration;
    }

    public Options getOptions() {
        if (this.options == null) {
            throw new IllegalStateException("options are not initialized");
        }
        return this.options;
    }

    public void setOptions(Options options) {
        if (options == null) {
            throw new NullPointerException("options cannot be null");
        }
        this.options = options;
    }

    public File getOutputDirectory(String outputDirKey) {
        File result = this.outputDirectoryMap.get(outputDirKey);
        if (result == null) {
            throw new IllegalStateException("The output directory for the key " + outputDirKey + "is not set");
        }
        return result;
    }

    public Map<String, File> getOutputDirectoryMap() {
        if (this.outputDirectoryMap.get(null) == null) {
            throw new IllegalStateException("outputDirectoryMap does not contain a mapping for the key null");
        }
        return Collections.unmodifiableMap(this.outputDirectoryMap);
    }

    public void setOutputDirectoryMap(Map<String, File> outputDirectoryMap) {
        if (outputDirectoryMap == null) {
            throw new NullPointerException("outputDirectoryMap may not be null");
        }
        if (outputDirectoryMap.get(null) == null) {
            throw new IllegalArgumentException("outputDirectoryMap(null) may not be null");
        }
        this.outputDirectoryMap.clear();
        this.outputDirectoryMap.putAll(outputDirectoryMap);
    }

    public File getWorkDirectory() {
        if (this.workDirectory == null) {
            throw new IllegalStateException("workDirectory is not initialized");
        }
        return this.workDirectory;
    }

    public void setWorkDirectory(File workDirectory) {
        if (workDirectory == null) {
            throw new NullPointerException("workDirectory cannot be null");
        }
        this.workDirectory = workDirectory;
    }

    public File getCacheDirectory() {
        if (this.cacheDirectory == null) {
            throw new IllegalStateException("cacheDirectory is not initialized");
        }
        return this.cacheDirectory;
    }

    public void setCacheDirectory(File cacheDirectory) {
        if (cacheDirectory == null) {
            throw new NullPointerException("cacheDirectory cannot be null");
        }
        this.cacheDirectory = cacheDirectory;
    }

    public void setOutputList(List<Output> outputList) {
        if (outputList == null) {
            throw new NullPointerException("outputList cannot be null");
        }
        this.outputList = outputList;
    }

    public List<Output> getOutputList() {
        if (this.outputList == null) {
            throw new IllegalStateException("outputFiles are not initialized");
        }
        return Collections.unmodifiableList(this.outputList);
    }

    public Loglevel getLoglevel() {
        if (this.loglevel == null) {
            throw new IllegalStateException("loglevel is not initialized");
        }
        return this.loglevel;
    }

    public void setLoglevel(Loglevel loglevel) {
        if (loglevel == null) {
            throw new NullPointerException("loglevel is null");
        }
        this.loglevel = loglevel;
    }

    public boolean isAddDebuggingInfoToOutput() {
        return this.addDebuggingInfoToOutput;
    }

    public void setAddDebuggingInfoToOutput(boolean addDebuggingInfoToOutput) {
        this.addDebuggingInfoToOutput = addDebuggingInfoToOutput;
    }

    public ConfigurationHandlers getConfigurationHandlers() {
        if (this.configurationHandlers == null) {
            throw new IllegalStateException("configurationHandlers is not initialized");
        }
        return this.configurationHandlers;
    }

    public void setConfigurationHandlers(ConfigurationHandlers configurationHandlers) {
        if (configurationHandlers == null) {
            throw new NullPointerException("configurationHandlers cannot be null");
        }
        this.configurationHandlers = configurationHandlers;
    }

    public SourceProvider getOverrideSourceProvider() {
        if (!this.overrideSourceProviderInitialized) {
            throw new IllegalStateException("overrideSourceProvider is not initialized");
        }
        return this.overrideSourceProvider;
    }

    public void setOverrideSourceProvider(SourceProvider overrideSourceProvider) {
        this.overrideSourceProvider = overrideSourceProvider;
        this.overrideSourceProviderInitialized = true;
    }

    public EntityReferences getEntityReferences() {
        if (this.entityReferences == null) {
            throw new IllegalStateException("entityReferences are not initialized");
        }
        return this.entityReferences;
    }

    public void setEntityReferences(EntityReferences entityReferences) {
        if (entityReferences == null) {
            throw new NullPointerException("entityReferences cannot be null");
        }
        this.entityReferences = entityReferences;
    }

    public String getDefaultOutputEncoding() {
        return this.defaultOutputEncoding;
    }

    public void setDefaultOutputEncoding(String defaultOutputEncoding) {
        this.defaultOutputEncoding = defaultOutputEncoding;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isRunOnlyOnSourceChange() {
        return this.runOnlyOnSourceChange;
    }

    public void setRunOnlyOnSourceChange(boolean runOnlyOnSourceChange) {
        this.runOnlyOnSourceChange = runOnlyOnSourceChange;
    }

    public String getTemplateSetName() {
        return this.templateSetName;
    }

    public void setTemplateSetName(String name) {
        this.templateSetName = name;
    }

    public boolean isInit() {
        return this.outputList != null && this.options != null && this.outletConfiguration != null && this.outputDirectoryMap.get(null) != null && this.loglevel != null && this.configurationHandlers != null && this.entityReferences != null && this.overrideSourceProviderInitialized && this.templateSetName != null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("(outputFiles=").append(this.outputList.toString()).append(", options=").append(this.options).append(", outletConfiguration=").append(this.outletConfiguration).append(", outputDirectoryMap=").append(this.outputDirectoryMap).append(", loglevel=").append((Object)this.loglevel).append(", name=").append(this.templateSetName).append(")");
        return result.toString();
    }
}

