/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.transform;

import java.util.function.DoubleUnaryOperator;
import java.util.function.UnaryOperator;
import org.apache.commons.math4.transform.FastFourierTransform;
import org.apache.commons.math4.transform.RealTransform;
import org.apache.commons.math4.transform.TransformException;
import org.apache.commons.math4.transform.TransformUtils;
import org.apache.commons.numbers.complex.Complex;
import org.apache.commons.numbers.core.ArithmeticUtils;

public class FastSineTransform
implements RealTransform {
    private final UnaryOperator<double[]> op;

    public FastSineTransform(Norm normalization, boolean inverse) {
        this.op = this.create(normalization, inverse);
    }

    public FastSineTransform(Norm normalization) {
        this(normalization, false);
    }

    @Override
    public double[] apply(double[] f) {
        return (double[])this.op.apply(f);
    }

    @Override
    public double[] apply(DoubleUnaryOperator f, double min, double max, int n) {
        double[] data = TransformUtils.sample(f, min, max, n);
        data[0] = 0.0;
        return this.apply(data);
    }

    private double[] fst(double[] f) {
        if (!ArithmeticUtils.isPowerOfTwo((long)f.length)) {
            throw new TransformException("{0} is not equal to pow(2, n), for some n", f.length);
        }
        if (f[0] != 0.0) {
            throw new TransformException("First element ({0}) must be 0", f[0]);
        }
        double[] transformed = new double[f.length];
        int n = f.length;
        if (n == 1) {
            transformed[0] = 0.0;
            return transformed;
        }
        double[] x = new double[n];
        x[0] = 0.0;
        int nShifted = n >> 1;
        x[nShifted] = 2.0 * f[nShifted];
        double piOverN = Math.PI / (double)n;
        for (int i = 1; i < nShifted; ++i) {
            int nMi = n - i;
            double fi = f[i];
            double fnMi = f[nMi];
            double a = Math.sin((double)i * piOverN) * (fi + fnMi);
            double b = 0.5 * (fi - fnMi);
            x[i] = a + b;
            x[nMi] = a - b;
        }
        FastFourierTransform transform = new FastFourierTransform(FastFourierTransform.Norm.STD);
        Complex[] y = transform.apply(x);
        transformed[0] = 0.0;
        transformed[1] = 0.5 * y[0].getReal();
        for (int i = 1; i < nShifted; ++i) {
            int i2 = 2 * i;
            transformed[i2] = -y[i].getImaginary();
            transformed[i2 + 1] = y[i].getReal() + transformed[i2 - 1];
        }
        return transformed;
    }

    private UnaryOperator<double[]> create(Norm normalization, boolean inverse) {
        if (inverse) {
            return normalization == Norm.ORTHO ? f -> TransformUtils.scaleInPlace(this.fst((double[])f), Math.sqrt(2.0 / (double)((double[])f).length)) : f -> TransformUtils.scaleInPlace(this.fst((double[])f), 2.0 / (double)((double[])f).length);
        }
        return normalization == Norm.ORTHO ? f -> TransformUtils.scaleInPlace(this.fst((double[])f), Math.sqrt(2.0 / (double)((double[])f).length)) : f -> this.fst((double[])f);
    }

    public static enum Norm {
        STD,
        ORTHO;

    }
}

