/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.neuralnet;

import java.util.List;
import org.apache.commons.math4.neuralnet.DistanceMeasure;
import org.apache.commons.math4.neuralnet.MapRanking;
import org.apache.commons.math4.neuralnet.Network;
import org.apache.commons.math4.neuralnet.Neuron;
import org.apache.commons.math4.neuralnet.internal.NeuralNetException;

public final class MapUtils {
    private MapUtils() {
    }

    public static double computeQuantizationError(Iterable<double[]> data, Iterable<Neuron> neurons, DistanceMeasure distance) {
        MapRanking rank = new MapRanking(neurons, distance);
        double d = 0.0;
        int count = 0;
        for (double[] f : data) {
            ++count;
            d += distance.applyAsDouble(f, rank.rank(f, 1).get(0).getFeatures());
        }
        if (count == 0) {
            throw new NeuralNetException("No data", new Object[0]);
        }
        return d / (double)count;
    }

    public static double computeTopographicError(Iterable<double[]> data, Network net, DistanceMeasure distance) {
        MapRanking rank = new MapRanking(net, distance);
        int notAdjacentCount = 0;
        int count = 0;
        for (double[] f : data) {
            ++count;
            List<Neuron> p = rank.rank(f, 2);
            if (net.getNeighbours(p.get(0)).contains(p.get(1))) continue;
            ++notAdjacentCount;
        }
        if (count == 0) {
            throw new NeuralNetException("No data", new Object[0]);
        }
        return (double)notAdjacentCount / (double)count;
    }
}

