/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.descriptive.summary;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.exception.MathIllegalArgumentException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class SumOfLogs
extends AbstractStorelessUnivariateStatistic {
    private int n;
    private double value;

    public SumOfLogs() {
        this.value = 0.0;
        this.n = 0;
    }

    public SumOfLogs(SumOfLogs original) throws NullArgumentException {
        SumOfLogs.copy(original, this);
    }

    @Override
    public void increment(double d) {
        this.value += JdkMath.log((double)d);
        ++this.n;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = 0.0;
        this.n = 0;
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        double sumLog = Double.NaN;
        if (MathArrays.verifyValues((double[])values, (int)begin, (int)length, (boolean)true)) {
            sumLog = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                sumLog += JdkMath.log((double)values[i]);
            }
        }
        return sumLog;
    }

    @Override
    public SumOfLogs copy() {
        SumOfLogs result = new SumOfLogs();
        SumOfLogs.copy(this, result);
        return result;
    }

    public static void copy(SumOfLogs source, SumOfLogs dest) throws NullArgumentException {
        NullArgumentException.check((Object)source);
        NullArgumentException.check((Object)dest);
        dest.n = source.n;
        dest.value = source.value;
    }
}

