/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.descriptive.rank;

import java.util.Arrays;
import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.stat.descriptive.rank.MedianOf3PivotingStrategy;
import org.apache.commons.math4.legacy.stat.descriptive.rank.PivotingStrategy;

public class KthSelector {
    private static final int MIN_SELECT_SIZE = 15;
    private final PivotingStrategy pivotingStrategy;

    public KthSelector() {
        this.pivotingStrategy = new MedianOf3PivotingStrategy();
    }

    public KthSelector(PivotingStrategy pivotingStrategy) {
        NullArgumentException.check((Object)pivotingStrategy);
        this.pivotingStrategy = pivotingStrategy;
    }

    public PivotingStrategy getPivotingStrategy() {
        return this.pivotingStrategy;
    }

    public double select(double[] work, int[] pivotsHeap, int k) {
        boolean usePivotsHeap;
        int begin = 0;
        int end = work.length;
        int node = 0;
        boolean bl = usePivotsHeap = pivotsHeap != null;
        while (end - begin > 15) {
            int pivot;
            if (usePivotsHeap && node < pivotsHeap.length && pivotsHeap[node] >= 0) {
                pivot = pivotsHeap[node];
            } else {
                pivot = this.partition(work, begin, end, this.pivotingStrategy.pivotIndex(work, begin, end));
                if (usePivotsHeap && node < pivotsHeap.length) {
                    pivotsHeap[node] = pivot;
                }
            }
            if (k == pivot) {
                return work[k];
            }
            if (k < pivot) {
                end = pivot;
                node = JdkMath.min((int)(2 * node + 1), (int)(usePivotsHeap ? pivotsHeap.length : end));
                continue;
            }
            begin = pivot + 1;
            node = JdkMath.min((int)(2 * node + 2), (int)(usePivotsHeap ? pivotsHeap.length : end));
        }
        Arrays.sort(work, begin, end);
        return work[k];
    }

    private int partition(double[] work, int begin, int end, int pivot) {
        double value = work[pivot];
        work[pivot] = work[begin];
        int i = begin + 1;
        int j = end - 1;
        while (i < j) {
            while (i < j && Double.compare(work[j], value) > 0) {
                --j;
            }
            while (i < j && Double.compare(work[i], value) < 0) {
                ++i;
            }
            if (i >= j) continue;
            double tmp = work[i];
            work[i++] = work[j];
            work[j--] = tmp;
        }
        if (i >= end || Double.compare(work[i], value) > 0) {
            --i;
        }
        work[begin] = work[i];
        work[i] = value;
        return i;
    }
}

