/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.ode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.math4.legacy.ode.Parameterizable;
import org.apache.commons.math4.legacy.ode.UnknownParameterException;

public abstract class AbstractParameterizable
implements Parameterizable {
    private final Collection<String> parametersNames;

    protected AbstractParameterizable(String ... names) {
        this.parametersNames = new ArrayList<String>(Arrays.asList(names));
    }

    protected AbstractParameterizable(Collection<String> names) {
        this.parametersNames = new ArrayList<String>(names);
    }

    @Override
    public Collection<String> getParametersNames() {
        return this.parametersNames;
    }

    @Override
    public boolean isSupported(String name) {
        for (String supportedName : this.parametersNames) {
            if (!supportedName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void complainIfNotSupported(String name) throws UnknownParameterException {
        if (!this.isSupported(name)) {
            throw new UnknownParameterException(name);
        }
    }
}

