/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.genetics;

import org.apache.commons.math4.legacy.exception.OutOfRangeException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.genetics.ChromosomePair;
import org.apache.commons.math4.legacy.genetics.CrossoverPolicy;
import org.apache.commons.math4.legacy.genetics.MutationPolicy;
import org.apache.commons.math4.legacy.genetics.Population;
import org.apache.commons.math4.legacy.genetics.SelectionPolicy;
import org.apache.commons.math4.legacy.genetics.StoppingCondition;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.simple.RandomSource;

public class GeneticAlgorithm {
    private static UniformRandomProvider randomGenerator = RandomSource.WELL_19937_C.create();
    private final CrossoverPolicy crossoverPolicy;
    private final double crossoverRate;
    private final MutationPolicy mutationPolicy;
    private final double mutationRate;
    private final SelectionPolicy selectionPolicy;
    private int generationsEvolved;

    public GeneticAlgorithm(CrossoverPolicy crossoverPolicy, double crossoverRate, MutationPolicy mutationPolicy, double mutationRate, SelectionPolicy selectionPolicy) throws OutOfRangeException {
        if (crossoverRate < 0.0 || crossoverRate > 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.CROSSOVER_RATE, (Number)crossoverRate, (Number)0, (Number)1);
        }
        if (mutationRate < 0.0 || mutationRate > 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.MUTATION_RATE, (Number)mutationRate, (Number)0, (Number)1);
        }
        this.crossoverPolicy = crossoverPolicy;
        this.crossoverRate = crossoverRate;
        this.mutationPolicy = mutationPolicy;
        this.mutationRate = mutationRate;
        this.selectionPolicy = selectionPolicy;
    }

    public static synchronized void setRandomGenerator(UniformRandomProvider random) {
        randomGenerator = random;
    }

    public static synchronized UniformRandomProvider getRandomGenerator() {
        return randomGenerator;
    }

    public Population evolve(Population initial, StoppingCondition condition) {
        Population current = initial;
        this.generationsEvolved = 0;
        while (!condition.isSatisfied(current)) {
            current = this.nextGeneration(current);
            ++this.generationsEvolved;
        }
        return current;
    }

    public Population nextGeneration(Population current) {
        Population nextGeneration = current.nextGeneration();
        UniformRandomProvider randGen = GeneticAlgorithm.getRandomGenerator();
        while (nextGeneration.getPopulationSize() < nextGeneration.getPopulationLimit()) {
            ChromosomePair pair = this.getSelectionPolicy().select(current);
            if (randGen.nextDouble() < this.getCrossoverRate()) {
                pair = this.getCrossoverPolicy().crossover(pair.getFirst(), pair.getSecond());
            }
            if (randGen.nextDouble() < this.getMutationRate()) {
                pair = new ChromosomePair(this.getMutationPolicy().mutate(pair.getFirst()), this.getMutationPolicy().mutate(pair.getSecond()));
            }
            nextGeneration.addChromosome(pair.getFirst());
            if (nextGeneration.getPopulationSize() >= nextGeneration.getPopulationLimit()) continue;
            nextGeneration.addChromosome(pair.getSecond());
        }
        return nextGeneration;
    }

    public CrossoverPolicy getCrossoverPolicy() {
        return this.crossoverPolicy;
    }

    public double getCrossoverRate() {
        return this.crossoverRate;
    }

    public MutationPolicy getMutationPolicy() {
        return this.mutationPolicy;
    }

    public double getMutationRate() {
        return this.mutationRate;
    }

    public SelectionPolicy getSelectionPolicy() {
        return this.selectionPolicy;
    }

    public int getGenerationsEvolved() {
        return this.generationsEvolved;
    }
}

