/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis.integration.gauss;

import org.apache.commons.math4.legacy.analysis.UnivariateFunction;
import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.core.Pair;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;

public class GaussIntegrator {
    private final double[] points;
    private final double[] weights;

    public GaussIntegrator(double[] points, double[] weights) {
        if (points.length != weights.length) {
            throw new DimensionMismatchException(points.length, weights.length);
        }
        MathArrays.checkOrder((double[])points, (MathArrays.OrderDirection)MathArrays.OrderDirection.INCREASING, (boolean)true, (boolean)true);
        this.points = (double[])points.clone();
        this.weights = (double[])weights.clone();
    }

    public GaussIntegrator(Pair<double[], double[]> pointsAndWeights) {
        this((double[])pointsAndWeights.getFirst(), (double[])pointsAndWeights.getSecond());
    }

    public double integrate(UnivariateFunction f) {
        double s = 0.0;
        double c = 0.0;
        for (int i = 0; i < this.points.length; ++i) {
            double x = this.points[i];
            double w = this.weights[i];
            double y = w * f.value(x) - c;
            double t = s + y;
            c = t - s - y;
            s = t;
        }
        return s;
    }

    public int getNumberOfPoints() {
        return this.points.length;
    }

    public double getPoint(int index) {
        return this.points[index];
    }

    public double getWeight(int index) {
        return this.weights[index];
    }
}

