/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl;

import java.io.StringReader;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionImpl;
import org.apache.commons.jexl.parser.ASTExpressionExpression;
import org.apache.commons.jexl.parser.ASTReferenceExpression;
import org.apache.commons.jexl.parser.Parser;
import org.apache.commons.jexl.parser.SimpleNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExpressionFactory {
    protected static Log log = LogFactory.getLog((String)"org.apache.commons.jexl.ExpressionFactory");
    protected static Parser parser = new Parser(new StringReader(";"));
    protected static ExpressionFactory ef = new ExpressionFactory();

    private ExpressionFactory() {
    }

    protected static ExpressionFactory getInstance() {
        return ef;
    }

    public static Expression createExpression(String expression) throws Exception {
        return ExpressionFactory.getInstance().createNewExpression(expression);
    }

    protected Expression createNewExpression(String expression) throws Exception {
        SimpleNode tree;
        String expr = this.cleanExpression(expression);
        Parser parser = ExpressionFactory.parser;
        synchronized (parser) {
            log.debug((Object)("Parsing expression: " + expr));
            tree = ExpressionFactory.parser.parse(new StringReader(expr));
        }
        SimpleNode node = (SimpleNode)tree.jjtGetChild(0);
        if (node instanceof ASTReferenceExpression || node instanceof ASTExpressionExpression) {
            node = (SimpleNode)node.jjtGetChild(0);
            ExpressionImpl e = new ExpressionImpl(expression, node);
            return e;
        }
        log.error((Object)("Invalid Expression, node of type: " + node.getClass().getName()));
        throw new Exception("Invalid Expression: neither Reference nor Expression");
    }

    private String cleanExpression(String expression) {
        String expr = expression.trim();
        if (!expr.endsWith(";")) {
            expr = String.valueOf(expr) + ";";
        }
        return expr;
    }
}

