/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.event.EventType;
import javax.cache.expiry.Duration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.management.ObjectName;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.ElementAttributes;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.control.event.behavior.IElementEventHandler;
import org.apache.commons.jcs3.jcache.Asserts;
import org.apache.commons.jcs3.jcache.EvictionListener;
import org.apache.commons.jcs3.jcache.ExpiryAwareCache;
import org.apache.commons.jcs3.jcache.JCSCacheEntryEvent;
import org.apache.commons.jcs3.jcache.JCSCachingManager;
import org.apache.commons.jcs3.jcache.JCSConfiguration;
import org.apache.commons.jcs3.jcache.JCSEntry;
import org.apache.commons.jcs3.jcache.JCSListener;
import org.apache.commons.jcs3.jcache.JCSMutableEntry;
import org.apache.commons.jcs3.jcache.NoLoader;
import org.apache.commons.jcs3.jcache.NoWriter;
import org.apache.commons.jcs3.jcache.Statistics;
import org.apache.commons.jcs3.jcache.TempStateCacheView;
import org.apache.commons.jcs3.jcache.Times;
import org.apache.commons.jcs3.jcache.jmx.JCSCacheMXBean;
import org.apache.commons.jcs3.jcache.jmx.JCSCacheStatisticsMXBean;
import org.apache.commons.jcs3.jcache.jmx.JMXs;
import org.apache.commons.jcs3.jcache.proxy.ExceptionWrapperHandler;
import org.apache.commons.jcs3.jcache.serialization.Serializations;
import org.apache.commons.jcs3.jcache.thread.DaemonThreadFactory;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class JCSCache<K, V>
implements Cache<K, V> {
    private final ExpiryAwareCache<K, V> delegate;
    private final JCSCachingManager manager;
    private final JCSConfiguration<K, V> config;
    private final CacheLoader<K, V> loader;
    private final CacheWriter<? super K, ? super V> writer;
    private final ExpiryPolicy expiryPolicy;
    private final ObjectName cacheConfigObjectName;
    private final ObjectName cacheStatsObjectName;
    private final String name;
    private volatile boolean closed;
    private final Map<CacheEntryListenerConfiguration<K, V>, JCSListener<K, V>> listeners = new ConcurrentHashMap<CacheEntryListenerConfiguration<K, V>, JCSListener<K, V>>();
    private final Statistics statistics = new Statistics();
    private final ExecutorService pool;
    private final IElementSerializer serializer;

    public JCSCache(ClassLoader classLoader, JCSCachingManager mgr, String cacheName, JCSConfiguration<K, V> configuration, Properties properties, ExpiryAwareCache<K, V> cache) {
        this.manager = mgr;
        this.name = cacheName;
        this.delegate = cache;
        if (this.delegate.getElementAttributes() == null) {
            this.delegate.setElementAttributes((IElementAttributes)new ElementAttributes());
        }
        this.delegate.getElementAttributes().addElementEventHandler((IElementEventHandler)new EvictionListener(this.statistics));
        this.config = configuration;
        int poolSize = Integer.parseInt(JCSCache.property(properties, cacheName, "pool.size", "3"));
        DaemonThreadFactory threadFactory = new DaemonThreadFactory("JCS-JCache-" + cacheName + "-");
        this.pool = poolSize > 0 ? Executors.newFixedThreadPool(poolSize, threadFactory) : Executors.newCachedThreadPool(threadFactory);
        try {
            this.serializer = (IElementSerializer)classLoader.loadClass(JCSCache.property(properties, "serializer", cacheName, StandardSerializer.class.getName())).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        Factory<CacheLoader<K, V>> cacheLoaderFactory = configuration.getCacheLoaderFactory();
        this.loader = cacheLoaderFactory == null ? NoLoader.INSTANCE : ExceptionWrapperHandler.newProxy(classLoader, (CacheLoader)cacheLoaderFactory.create(), CacheLoaderException.class, CacheLoader.class);
        Factory<CacheWriter<K, V>> cacheWriterFactory = configuration.getCacheWriterFactory();
        this.writer = cacheWriterFactory == null ? NoWriter.INSTANCE : ExceptionWrapperHandler.newProxy(classLoader, (CacheWriter)cacheWriterFactory.create(), CacheWriterException.class, CacheWriter.class);
        Factory<ExpiryPolicy> expiryPolicyFactory = configuration.getExpiryPolicyFactory();
        this.expiryPolicy = expiryPolicyFactory == null ? new EternalExpiryPolicy() : (ExpiryPolicy)expiryPolicyFactory.create();
        for (CacheEntryListenerConfiguration<K, V> listener : this.config.getCacheEntryListenerConfigurations()) {
            this.listeners.put(listener, new JCSListener<K, V>(listener));
        }
        this.delegate.init(this, this.listeners);
        this.statistics.setActive(this.config.isStatisticsEnabled());
        String mgrStr = this.manager.getURI().toString().replaceAll(",|:|=|\n", ".");
        String cacheStr = this.name.replaceAll(",|:|=|\n", ".");
        try {
            this.cacheConfigObjectName = new ObjectName("javax.cache:type=CacheConfiguration,CacheManager=" + mgrStr + ",Cache=" + cacheStr);
            this.cacheStatsObjectName = new ObjectName("javax.cache:type=CacheStatistics,CacheManager=" + mgrStr + ",Cache=" + cacheStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (this.config.isManagementEnabled()) {
            JMXs.register(this.cacheConfigObjectName, new JCSCacheMXBean(this));
        }
        if (this.config.isStatisticsEnabled()) {
            JMXs.register(this.cacheStatsObjectName, new JCSCacheStatisticsMXBean(this.statistics));
        }
    }

    private static String property(Properties properties, String cacheName, String name, String defaultValue) {
        return properties.getProperty(cacheName + "." + name, properties.getProperty(name, defaultValue));
    }

    private void assertNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("cache closed");
        }
    }

    public V get(K key) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        long getStart = Times.now(false);
        return this.doGetControllingExpiry(getStart, key, true, false, false, true);
    }

    private V doLoad(K key, boolean update, long now, boolean propagateLoadException) {
        Object v;
        block7: {
            v = null;
            try {
                v = this.loader.load(key);
            }
            catch (CacheLoaderException e) {
                if (!propagateLoadException) break block7;
                throw e;
            }
        }
        if (v != null) {
            Duration duration;
            Duration duration2 = duration = update ? this.expiryPolicy.getExpiryForUpdate() : this.expiryPolicy.getExpiryForCreation();
            if (JCSCache.isNotZero(duration)) {
                IElementAttributes clone = this.delegate.getElementAttributes().clone();
                if (ElementAttributes.class.isInstance(clone)) {
                    ((ElementAttributes)ElementAttributes.class.cast(clone)).setCreateTime();
                }
                ICacheElement<K, Object> element = this.updateElement(key, v, duration, clone);
                try {
                    this.delegate.update(element);
                }
                catch (IOException e) {
                    throw new CacheException((Throwable)e);
                }
            }
        }
        return (V)v;
    }

    private ICacheElement<K, V> updateElement(K key, V v, Duration duration, IElementAttributes attrs) {
        CacheElement element = new CacheElement(this.name, key, v);
        if (duration != null) {
            attrs.setTimeFactorForMilliseconds(1L);
            boolean eternal = duration.isEternal();
            attrs.setIsEternal(eternal);
            if (!eternal) {
                attrs.setLastAccessTimeNow();
            }
        }
        element.setElementAttributes(attrs);
        return element;
    }

    private void touch(K key, ICacheElement<K, V> element) {
        if (this.config.isStoreByValue()) {
            K copy = Serializations.copy(this.serializer, this.manager.getClassLoader(), key);
            try {
                this.delegate.update((ICacheElement)new CacheElement(this.name, copy, element.getVal(), element.getElementAttributes()));
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.assertNotClosed();
        for (K k : keys) {
            Asserts.assertNotNull(k, "key");
        }
        long now = Times.now(false);
        HashMap<K, Object> result = new HashMap<K, Object>();
        for (K key : keys) {
            Object val;
            Asserts.assertNotNull(key, "key");
            ICacheElement elt = this.delegate.get(key);
            Object object = val = elt != null ? elt.getVal() : null;
            if (val == null && this.config.isReadThrough()) {
                val = this.doLoad(key, false, now, false);
                if (val == null) continue;
                result.put(key, val);
                continue;
            }
            if (elt == null) continue;
            Duration expiryForAccess = this.expiryPolicy.getExpiryForAccess();
            if (JCSCache.isNotZero(expiryForAccess)) {
                this.touch(key, elt);
                result.put(key, val);
                continue;
            }
            this.forceExpires(key);
        }
        return result;
    }

    public boolean containsKey(K key) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        return this.delegate.get(key) != null;
    }

    public void put(K key, V rawValue) {
        Duration duration;
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        Asserts.assertNotNull(rawValue, "value");
        ICacheElement oldElt = this.delegate.get(key);
        Object old = oldElt != null ? oldElt.getVal() : null;
        boolean storeByValue = this.config.isStoreByValue();
        V value = storeByValue ? Serializations.copy(this.serializer, this.manager.getClassLoader(), rawValue) : rawValue;
        boolean created = old == null;
        Duration duration2 = duration = created ? this.expiryPolicy.getExpiryForCreation() : this.expiryPolicy.getExpiryForUpdate();
        if (JCSCache.isNotZero(duration)) {
            boolean statisticsEnabled = this.config.isStatisticsEnabled();
            long start = Times.now(false);
            K jcsKey = storeByValue ? Serializations.copy(this.serializer, this.manager.getClassLoader(), key) : key;
            ICacheElement<K, V> element = this.updateElement(jcsKey, value, created ? null : duration, oldElt != null ? oldElt.getElementAttributes() : this.delegate.getElementAttributes().clone());
            if (created && duration != null) {
                IElementAttributes copy = element.getElementAttributes();
                copy.setTimeFactorForMilliseconds(1L);
                boolean bl = duration.isEternal();
                copy.setIsEternal(bl);
                if (ElementAttributes.class.isInstance(copy)) {
                    ((ElementAttributes)ElementAttributes.class.cast(copy)).setCreateTime();
                }
                if (!bl) {
                    copy.setIsEternal(false);
                    if (duration == this.expiryPolicy.getExpiryForAccess()) {
                        element.getElementAttributes().setIdleTime(duration.getTimeUnit().toMillis(duration.getDurationAmount()));
                    } else {
                        element.getElementAttributes().setMaxLife(duration.getTimeUnit().toMillis(duration.getDurationAmount()));
                    }
                }
                element.setElementAttributes(copy);
            }
            this.writer.write(new JCSEntry<K, V>(jcsKey, value));
            try {
                this.delegate.update(element);
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
            for (JCSListener<Object, Object> jCSListener : this.listeners.values()) {
                if (created) {
                    jCSListener.onCreated(Collections.singletonList(new JCSCacheEntryEvent<K, Object>(this, EventType.CREATED, null, key, value)));
                    continue;
                }
                jCSListener.onUpdated(Collections.singletonList(new JCSCacheEntryEvent<K, Object>(this, EventType.UPDATED, old, key, value)));
            }
            if (statisticsEnabled) {
                this.statistics.increasePuts(1L);
                this.statistics.addPutTime(System.currentTimeMillis() - start);
            }
        } else if (!created) {
            this.forceExpires(key);
        }
    }

    private static boolean isNotZero(Duration duration) {
        return duration == null || !duration.isZero();
    }

    private void forceExpires(K cacheKey) {
        ICacheElement elt = this.delegate.get(cacheKey);
        this.delegate.remove(cacheKey);
        for (JCSListener jCSListener : this.listeners.values()) {
            jCSListener.onExpired(Collections.singletonList(new JCSCacheEntryEvent<K, Object>(this, EventType.REMOVED, null, cacheKey, elt.getVal())));
        }
    }

    public V getAndPut(K key, V value) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        Asserts.assertNotNull(value, "value");
        long getStart = Times.now(false);
        V v = this.doGetControllingExpiry(getStart, key, false, false, true, false);
        this.put(key, value);
        return v;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.assertNotClosed();
        TempStateCacheView<K, V> view = new TempStateCacheView<K, V>(this);
        for (Map.Entry<K, V> e : map.entrySet()) {
            view.put(e.getKey(), e.getValue());
        }
        view.merge();
    }

    public boolean putIfAbsent(K key, V value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public boolean remove(K key) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        boolean statisticsEnabled = this.config.isStatisticsEnabled();
        long start = Times.now(!statisticsEnabled);
        this.writer.delete(key);
        ICacheElement v = this.delegate.get(key);
        this.delegate.remove(key);
        Object value = v != null && v.getVal() != null ? v.getVal() : null;
        boolean remove = v != null;
        for (JCSListener jCSListener : this.listeners.values()) {
            jCSListener.onRemoved(Collections.singletonList(new JCSCacheEntryEvent<K, Object>(this, EventType.REMOVED, null, key, value)));
        }
        if (remove && statisticsEnabled) {
            this.statistics.increaseRemovals(1L);
            this.statistics.addRemoveTime(Times.now(false) - start);
        }
        return remove;
    }

    public boolean remove(K key, V oldValue) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        Asserts.assertNotNull(oldValue, "oldValue");
        long getStart = Times.now(false);
        V v = this.doGetControllingExpiry(getStart, key, false, false, false, false);
        if (oldValue.equals(v)) {
            this.remove(key);
            return true;
        }
        if (v != null) {
            this.expiryPolicy.getExpiryForAccess();
        }
        return false;
    }

    public V getAndRemove(K key) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        long getStart = Times.now(false);
        V v = this.doGetControllingExpiry(getStart, key, false, false, true, false);
        this.remove(key);
        return v;
    }

    private V doGetControllingExpiry(long getStart, K key, boolean updateAcess, boolean forceDoLoad, boolean skipLoad, boolean propagateLoadException) {
        Object v;
        boolean statisticsEnabled = this.config.isStatisticsEnabled();
        ICacheElement elt = this.delegate.get(key);
        Object object = v = elt != null ? elt.getVal() : null;
        if (v == null && (this.config.isReadThrough() || forceDoLoad)) {
            if (!skipLoad) {
                v = this.doLoad(key, false, getStart, propagateLoadException);
            }
        } else if (statisticsEnabled) {
            if (v != null) {
                this.statistics.increaseHits(1L);
            } else {
                this.statistics.increaseMisses(1L);
            }
        }
        if (updateAcess && elt != null) {
            Duration expiryForAccess = this.expiryPolicy.getExpiryForAccess();
            if (!JCSCache.isNotZero(expiryForAccess)) {
                this.forceExpires(key);
            } else if (!(expiryForAccess == null || elt.getElementAttributes().getIsEternal() && expiryForAccess.isEternal())) {
                try {
                    this.delegate.update(this.updateElement(key, elt.getVal(), expiryForAccess, elt.getElementAttributes()));
                }
                catch (IOException e) {
                    throw new CacheException((Throwable)e);
                }
            }
        }
        if (statisticsEnabled && v != null) {
            this.statistics.addGetTime(Times.now(false) - getStart);
        }
        return (V)v;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        Asserts.assertNotNull(oldValue, "oldValue");
        Asserts.assertNotNull(newValue, "newValue");
        boolean statisticsEnabled = this.config.isStatisticsEnabled();
        ICacheElement elt = this.delegate.get(key);
        if (elt != null) {
            Duration expiryForAccess;
            Object value = elt.getVal();
            if (value != null && statisticsEnabled) {
                this.statistics.increaseHits(1L);
            }
            if (value == null && this.config.isReadThrough()) {
                value = this.doLoad(key, false, Times.now(false), false);
            }
            if (value != null && value.equals(oldValue)) {
                this.put(key, newValue);
                return true;
            }
            if (!(value == null || (expiryForAccess = this.expiryPolicy.getExpiryForAccess()) == null || elt.getElementAttributes().getIsEternal() && expiryForAccess.isEternal())) {
                try {
                    this.delegate.update(this.updateElement(key, elt.getVal(), expiryForAccess, elt.getElementAttributes()));
                }
                catch (IOException e) {
                    throw new CacheException((Throwable)e);
                }
            }
        } else if (statisticsEnabled) {
            this.statistics.increaseMisses(1L);
        }
        return false;
    }

    public boolean replace(K key, V value) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        Asserts.assertNotNull(value, "value");
        boolean statisticsEnabled = this.config.isStatisticsEnabled();
        if (this.containsKey(key)) {
            if (statisticsEnabled) {
                this.statistics.increaseHits(1L);
            }
            this.put(key, value);
            return true;
        }
        if (statisticsEnabled) {
            this.statistics.increaseMisses(1L);
        }
        return false;
    }

    public V getAndReplace(K key, V value) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        Asserts.assertNotNull(value, "value");
        boolean statisticsEnabled = this.config.isStatisticsEnabled();
        ICacheElement elt = this.delegate.get(key);
        if (elt != null) {
            Object oldValue = elt.getVal();
            if (oldValue == null && this.config.isReadThrough()) {
                oldValue = this.doLoad(key, false, Times.now(false), false);
            } else if (statisticsEnabled) {
                this.statistics.increaseHits(1L);
            }
            this.put(key, value);
            return (V)oldValue;
        }
        if (statisticsEnabled) {
            this.statistics.increaseMisses(1L);
        }
        return null;
    }

    public void removeAll(Set<? extends K> keys) {
        this.assertNotClosed();
        Asserts.assertNotNull(keys, "keys");
        for (K k : keys) {
            this.remove(k);
        }
    }

    public void removeAll() {
        this.assertNotClosed();
        for (Object k : this.delegate.getKeySet()) {
            this.remove(k);
        }
    }

    public void clear() {
        this.assertNotClosed();
        try {
            this.delegate.removeAll();
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public <C2 extends Configuration<K, V>> C2 getConfiguration(Class<C2> clazz) {
        this.assertNotClosed();
        return (C2)((Configuration)clazz.cast(this.config));
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.assertNotClosed();
        Asserts.assertNotNull(keys, "keys");
        for (K k : keys) {
            Asserts.assertNotNull(k, "a key");
        }
        this.pool.submit(() -> this.doLoadAll(keys, replaceExistingValues, completionListener));
    }

    private void doLoadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        block5: {
            try {
                long now = Times.now(false);
                for (K k : keys) {
                    if (replaceExistingValues) {
                        this.doLoad(k, this.containsKey(k), now, completionListener != null);
                        continue;
                    }
                    if (this.containsKey(k)) continue;
                    this.doGetControllingExpiry(now, k, true, true, false, completionListener != null);
                }
            }
            catch (RuntimeException e) {
                if (completionListener == null) break block5;
                completionListener.onException((Exception)e);
                return;
            }
        }
        if (completionListener != null) {
            completionListener.onCompletion();
        }
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        TempStateCacheView view = new TempStateCacheView(this);
        T t = this.doInvoke(view, key, entryProcessor, arguments);
        view.merge();
        return t;
    }

    private <T> T doInvoke(TempStateCacheView<K, V> view, K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.assertNotClosed();
        Asserts.assertNotNull(entryProcessor, "entryProcessor");
        Asserts.assertNotNull(key, "key");
        try {
            if (this.config.isStatisticsEnabled()) {
                if (this.containsKey(key)) {
                    this.statistics.increaseHits(1L);
                } else {
                    this.statistics.increaseMisses(1L);
                }
            }
            return (T)entryProcessor.process(new JCSMutableEntry<K, V>(view, key), arguments);
        }
        catch (Exception ex) {
            return JCSCache.throwEntryProcessorException(ex);
        }
    }

    private static <T> T throwEntryProcessorException(Exception ex) {
        if (EntryProcessorException.class.isInstance(ex)) {
            throw (EntryProcessorException)EntryProcessorException.class.cast(ex);
        }
        throw new EntryProcessorException((Throwable)ex);
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.assertNotClosed();
        Asserts.assertNotNull(entryProcessor, "entryProcessor");
        HashMap<K, EntryProcessorResult> results = new HashMap<K, EntryProcessorResult>();
        for (K k : keys) {
            try {
                Object invoke = this.invoke(k, entryProcessor, arguments);
                if (invoke == null) continue;
                results.put(k, () -> invoke);
            }
            catch (Exception e) {
                results.put(k, () -> JCSCache.throwEntryProcessorException(e));
            }
        }
        return results;
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.assertNotClosed();
        if (this.listeners.containsKey(cacheEntryListenerConfiguration)) {
            throw new IllegalArgumentException(cacheEntryListenerConfiguration + " already registered");
        }
        this.listeners.put(cacheEntryListenerConfiguration, new JCSListener<K, V>(cacheEntryListenerConfiguration));
        this.config.addListener(cacheEntryListenerConfiguration);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.assertNotClosed();
        this.listeners.remove(cacheEntryListenerConfiguration);
        this.config.removeListener(cacheEntryListenerConfiguration);
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.assertNotClosed();
        final Iterator keys = new HashSet(this.delegate.getKeySet()).iterator();
        return new Iterator<Cache.Entry<K, V>>(){
            private K lastKey;

            @Override
            public boolean hasNext() {
                return keys.hasNext();
            }

            @Override
            public Cache.Entry<K, V> next() {
                this.lastKey = keys.next();
                return new JCSEntry(this.lastKey, JCSCache.this.get(this.lastKey));
            }

            @Override
            public void remove() {
                if (JCSCache.this.isClosed() || this.lastKey == null) {
                    throw new IllegalStateException(JCSCache.this.isClosed() ? "cache closed" : "call next() before remove()");
                }
                JCSCache.this.remove(this.lastKey);
            }
        };
    }

    public String getName() {
        this.assertNotClosed();
        return this.name;
    }

    public CacheManager getCacheManager() {
        this.assertNotClosed();
        return this.manager;
    }

    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        for (Runnable runnable : this.pool.shutdownNow()) {
            runnable.run();
        }
        this.manager.release(this.getName());
        this.closed = true;
        JCSCache.close(this.loader);
        JCSCache.close(this.writer);
        JCSCache.close(this.expiryPolicy);
        for (JCSListener jCSListener : this.listeners.values()) {
            JCSCache.close(jCSListener);
        }
        this.listeners.clear();
        JMXs.unregister(this.cacheConfigObjectName);
        JMXs.unregister(this.cacheStatsObjectName);
        try {
            this.delegate.removeAll();
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static void close(Object potentiallyCloseable) {
        if (Closeable.class.isInstance(potentiallyCloseable)) {
            Closeable.class.cast(potentiallyCloseable);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public <T> T unwrap(Class<T> clazz) {
        this.assertNotClosed();
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(Map.class) || clazz.isAssignableFrom(ConcurrentMap.class)) {
            return clazz.cast(this.delegate);
        }
        throw new IllegalArgumentException(clazz.getName() + " not supported in unwrap");
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public void enableManagement() {
        this.config.managementEnabled();
        JMXs.register(this.cacheConfigObjectName, new JCSCacheMXBean(this));
    }

    public void disableManagement() {
        this.config.managementDisabled();
        JMXs.unregister(this.cacheConfigObjectName);
    }

    public void enableStatistics() {
        this.config.statisticsEnabled();
        this.statistics.setActive(true);
        JMXs.register(this.cacheStatsObjectName, new JCSCacheStatisticsMXBean(this.statistics));
    }

    public void disableStatistics() {
        this.config.statisticsDisabled();
        this.statistics.setActive(false);
        JMXs.unregister(this.cacheStatsObjectName);
    }
}

