/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.Region;
import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.internal.HyperplaneSubsets;
import org.apache.commons.geometry.core.partitioning.EmbeddingHyperplane;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.partitioning.SplitLocation;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTree;
import org.apache.commons.geometry.euclidean.oned.Interval;
import org.apache.commons.geometry.euclidean.oned.OrientedPoint;
import org.apache.commons.geometry.euclidean.oned.OrientedPoints;
import org.apache.commons.geometry.euclidean.oned.RegionBSPTree1D;
import org.apache.commons.geometry.euclidean.oned.Vector1D;
import org.apache.commons.geometry.euclidean.twod.Bounds2D;
import org.apache.commons.geometry.euclidean.twod.Line;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.LineSubset;
import org.apache.commons.geometry.euclidean.twod.Lines;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.numbers.core.Precision;

public final class EmbeddedTreeLineSubset
extends LineSubset {
    private final RegionBSPTree1D region;

    public EmbeddedTreeLineSubset(Line line) {
        this(line, false);
    }

    public EmbeddedTreeLineSubset(Line line, boolean full) {
        this(line, new RegionBSPTree1D(full));
    }

    public EmbeddedTreeLineSubset(Line line, RegionBSPTree1D region) {
        super(line);
        this.region = region;
    }

    public boolean isFull() {
        return this.region.isFull();
    }

    public boolean isEmpty() {
        return this.region.isEmpty();
    }

    public double getSize() {
        return this.region.getSize();
    }

    public Vector2D getCentroid() {
        Vector1D subspaceCentroid = (Vector1D)this.region.getCentroid();
        if (subspaceCentroid != null) {
            return this.getLine().toSpace(subspaceCentroid);
        }
        return null;
    }

    @Override
    public Bounds2D getBounds() {
        double min = this.region.getMin();
        double max = this.region.getMax();
        if (Double.isFinite(min) && Double.isFinite(max)) {
            Line line = this.getLine();
            return Bounds2D.builder().add(line.toSpace(min)).add(line.toSpace(max)).build();
        }
        return null;
    }

    public Vector2D closest(Vector2D pt) {
        return (Vector2D)HyperplaneSubsets.closestToEmbeddedRegion((Point)pt, (EmbeddingHyperplane)this.getLine(), (Region)this.region);
    }

    public EmbeddedTreeLineSubset transform(Transform<Vector2D> transform) {
        Line.SubspaceTransform st = this.getLine().subspaceTransform(transform);
        RegionBSPTree1D tRegion = RegionBSPTree1D.empty();
        tRegion.copy((BSPTree)this.region);
        tRegion.transform(st.getTransform());
        return new EmbeddedTreeLineSubset(st.getLine(), tRegion);
    }

    @Override
    public List<LineConvexSubset> toConvex() {
        List<Interval> intervals = this.region.toIntervals();
        Line line = this.getLine();
        ArrayList<LineConvexSubset> convexSubsets = new ArrayList<LineConvexSubset>(intervals.size());
        for (Interval interval : intervals) {
            convexSubsets.add(Lines.subsetFromInterval(line, interval));
        }
        return convexSubsets;
    }

    public RegionBSPTree1D getSubspaceRegion() {
        return this.region;
    }

    public Split<EmbeddedTreeLineSubset> split(Hyperplane<Vector2D> splitter) {
        Line thisLine = this.getLine();
        Line splitterLine = (Line)splitter;
        Precision.DoubleEquivalence precision = this.getPrecision();
        Vector2D intersection = splitterLine.intersection(thisLine);
        if (intersection == null) {
            return this.getNonIntersectingSplitResult(splitterLine, this);
        }
        double abscissa = thisLine.abscissa(intersection);
        OrientedPoint subspaceSplitter = OrientedPoints.fromLocationAndDirection(abscissa, this.splitterPlusIsPositiveFacing(splitterLine), precision);
        Split<RegionBSPTree1D> subspaceSplit = this.region.split((Hyperplane<Vector1D>)subspaceSplitter);
        SplitLocation subspaceSplitLoc = subspaceSplit.getLocation();
        if (SplitLocation.MINUS == subspaceSplitLoc) {
            return new Split((Object)this, null);
        }
        if (SplitLocation.PLUS == subspaceSplitLoc) {
            return new Split(null, (Object)this);
        }
        EmbeddedTreeLineSubset minus = subspaceSplit.getMinus() != null ? new EmbeddedTreeLineSubset(thisLine, (RegionBSPTree1D)((Object)subspaceSplit.getMinus())) : null;
        EmbeddedTreeLineSubset plus = subspaceSplit.getPlus() != null ? new EmbeddedTreeLineSubset(thisLine, (RegionBSPTree1D)((Object)subspaceSplit.getPlus())) : null;
        return new Split((Object)minus, (Object)plus);
    }

    public void add(LineConvexSubset subset) {
        Lines.validateLinesEquivalent(this.getLine(), subset.getLine());
        this.region.add(subset.getInterval());
    }

    public void add(EmbeddedTreeLineSubset subset) {
        Lines.validateLinesEquivalent(this.getLine(), subset.getLine());
        this.region.union(subset.getSubspaceRegion());
    }

    public String toString() {
        Line line = this.getLine();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[').append("lineOrigin= ").append(line.getOrigin()).append(", lineDirection= ").append(line.getDirection()).append(", region= ").append((Object)this.region).append(']');
        return sb.toString();
    }

    @Override
    RegionLocation classifyAbscissa(double abscissa) {
        return this.region.classify(abscissa);
    }
}

