/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.partitioning.HyperplaneSubset;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractBSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractPartitionedRegionBuilder;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractRegionBSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTreeVisitor;
import org.apache.commons.geometry.core.partitioning.bsp.RegionCutBoundary;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.Bounds3D;
import org.apache.commons.geometry.euclidean.threed.ConvexVolume;
import org.apache.commons.geometry.euclidean.threed.Plane;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.PlaneSubset;
import org.apache.commons.geometry.euclidean.threed.Planes;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.line.Line3D;
import org.apache.commons.geometry.euclidean.threed.line.LineConvexSubset3D;
import org.apache.commons.geometry.euclidean.threed.line.LinecastPoint3D;
import org.apache.commons.numbers.core.Precision;

public final class RegionBSPTree3D
extends AbstractRegionBSPTree<Vector3D, RegionNode3D>
implements BoundarySource3D {
    public RegionBSPTree3D() {
        this(false);
    }

    public RegionBSPTree3D(boolean full) {
        super(full);
    }

    public RegionBSPTree3D copy() {
        RegionBSPTree3D result = RegionBSPTree3D.empty();
        result.copy((BSPTree)this);
        return result;
    }

    public Iterable<PlaneConvexSubset> boundaries() {
        return this.createBoundaryIterable(PlaneConvexSubset.class::cast);
    }

    public Stream<PlaneConvexSubset> boundaryStream() {
        return StreamSupport.stream(this.boundaries().spliterator(), false);
    }

    public List<PlaneConvexSubset> getBoundaries() {
        return this.createBoundaryList(PlaneConvexSubset.class::cast);
    }

    public List<ConvexVolume> toConvex() {
        ArrayList<ConvexVolume> result = new ArrayList<ConvexVolume>();
        this.toConvexRecursive((RegionNode3D)this.getRoot(), ConvexVolume.full(), result);
        return result;
    }

    private void toConvexRecursive(RegionNode3D node, ConvexVolume nodeVolume, List<? super ConvexVolume> result) {
        if (node.isLeaf()) {
            if (node.isInside()) {
                result.add(nodeVolume);
            }
        } else {
            Split<ConvexVolume> split = nodeVolume.split((Hyperplane<Vector3D>)node.getCutHyperplane());
            this.toConvexRecursive((RegionNode3D)node.getMinus(), (ConvexVolume)split.getMinus(), result);
            this.toConvexRecursive((RegionNode3D)node.getPlus(), (ConvexVolume)split.getPlus(), result);
        }
    }

    public Split<RegionBSPTree3D> split(Hyperplane<Vector3D> splitter) {
        return this.split(splitter, RegionBSPTree3D.empty(), RegionBSPTree3D.empty());
    }

    public Vector3D project(Vector3D pt) {
        BoundaryProjector3D projector = new BoundaryProjector3D(pt);
        this.accept((BSPTreeVisitor)projector);
        return (Vector3D)projector.getProjected();
    }

    @Override
    public RegionBSPTree3D toTree() {
        return this;
    }

    @Override
    public List<LinecastPoint3D> linecast(LineConvexSubset3D subset) {
        LinecastVisitor visitor = new LinecastVisitor(subset, false);
        this.accept(visitor);
        return visitor.getResults();
    }

    @Override
    public LinecastPoint3D linecastFirst(LineConvexSubset3D subset) {
        LinecastVisitor visitor = new LinecastVisitor(subset, true);
        this.accept(visitor);
        return visitor.getFirstResult();
    }

    protected AbstractRegionBSPTree.RegionSizeProperties<Vector3D> computeRegionSizeProperties() {
        if (this.isFull()) {
            return new AbstractRegionBSPTree.RegionSizeProperties(Double.POSITIVE_INFINITY, null);
        }
        if (this.isEmpty()) {
            return new AbstractRegionBSPTree.RegionSizeProperties(0.0, null);
        }
        RegionSizePropertiesVisitor visitor = new RegionSizePropertiesVisitor();
        this.accept(visitor);
        return visitor.getRegionSizeProperties();
    }

    protected RegionNode3D createNode() {
        return new RegionNode3D((AbstractBSPTree<Vector3D, RegionNode3D>)this);
    }

    public static RegionBSPTree3D full() {
        return new RegionBSPTree3D(true);
    }

    public static RegionBSPTree3D empty() {
        return new RegionBSPTree3D(false);
    }

    public static RegionBSPTree3D from(Iterable<? extends PlaneConvexSubset> boundaries) {
        return RegionBSPTree3D.from(boundaries, false);
    }

    public static RegionBSPTree3D from(Iterable<? extends PlaneConvexSubset> boundaries, boolean full) {
        RegionBSPTree3D tree = new RegionBSPTree3D(full);
        tree.insert(boundaries);
        return tree;
    }

    public static PartitionedRegionBuilder3D partitionedRegionBuilder() {
        return new PartitionedRegionBuilder3D();
    }

    private static final class LinecastVisitor
    implements BSPTreeVisitor<Vector3D, RegionNode3D> {
        private final LineConvexSubset3D linecastSubset;
        private final boolean firstOnly;
        private double minAbscissa = Double.POSITIVE_INFINITY;
        private final List<LinecastPoint3D> results = new ArrayList<LinecastPoint3D>();

        LinecastVisitor(LineConvexSubset3D linecastSubset, boolean firstOnly) {
            this.linecastSubset = linecastSubset;
            this.firstOnly = firstOnly;
        }

        public LinecastPoint3D getFirstResult() {
            List<LinecastPoint3D> sortedResults = this.getResults();
            return sortedResults.isEmpty() ? null : sortedResults.get(0);
        }

        public List<LinecastPoint3D> getResults() {
            LinecastPoint3D.sortAndFilter(this.results);
            return this.results;
        }

        public BSPTreeVisitor.Order visitOrder(RegionNode3D internalNode) {
            Plane cut = (Plane)internalNode.getCutHyperplane();
            Line3D line = this.linecastSubset.getLine();
            boolean plusIsNear = line.getDirection().dot(cut.getNormal()) < 0.0;
            return plusIsNear ? BSPTreeVisitor.Order.PLUS_NODE_MINUS : BSPTreeVisitor.Order.MINUS_NODE_PLUS;
        }

        public BSPTreeVisitor.Result visit(RegionNode3D node) {
            if (node.isInternal()) {
                Line3D line = this.linecastSubset.getLine();
                Vector3D pt = ((Plane)node.getCutHyperplane()).intersection(line);
                if (pt != null) {
                    LinecastPoint3D potentialResult;
                    if (this.firstOnly && !this.results.isEmpty() && line.getPrecision().compare(this.minAbscissa, line.abscissa(pt)) < 0) {
                        return BSPTreeVisitor.Result.TERMINATE;
                    }
                    if (this.linecastSubset.contains(pt) && (potentialResult = this.computeLinecastPoint(pt, node)) != null) {
                        this.results.add(potentialResult);
                        this.minAbscissa = Math.min(this.minAbscissa, potentialResult.getAbscissa());
                    }
                }
            }
            return BSPTreeVisitor.Result.CONTINUE;
        }

        private LinecastPoint3D computeLinecastPoint(Vector3D pt, RegionNode3D node) {
            Plane cut = (Plane)node.getCutHyperplane();
            RegionCutBoundary boundary = node.getCutBoundary();
            boolean onBoundary = false;
            boolean negateNormal = false;
            if (boundary.containsInsideFacing((Point)pt)) {
                onBoundary = true;
                negateNormal = true;
            } else if (boundary.containsOutsideFacing((Point)pt)) {
                onBoundary = true;
            }
            if (onBoundary) {
                Vector3D normal = cut.getNormal();
                if (negateNormal) {
                    normal = ((Vector3D)normal).negate();
                }
                return new LinecastPoint3D(pt, normal, this.linecastSubset.getLine());
            }
            return null;
        }
    }

    private static final class RegionSizePropertiesVisitor
    implements BSPTreeVisitor<Vector3D, RegionNode3D> {
        private double volumeSum;
        private double sumX;
        private double sumY;
        private double sumZ;

        private RegionSizePropertiesVisitor() {
        }

        public BSPTreeVisitor.Result visit(RegionNode3D node) {
            if (node.isInternal()) {
                RegionCutBoundary boundary = node.getCutBoundary();
                for (HyperplaneConvexSubset outsideFacing : boundary.getOutsideFacing()) {
                    this.addBoundaryContribution((HyperplaneSubset<Vector3D>)outsideFacing, false);
                }
                for (HyperplaneConvexSubset insideFacing : boundary.getInsideFacing()) {
                    this.addBoundaryContribution((HyperplaneSubset<Vector3D>)insideFacing, true);
                }
            }
            return BSPTreeVisitor.Result.CONTINUE;
        }

        public AbstractRegionBSPTree.RegionSizeProperties<Vector3D> getRegionSizeProperties() {
            double size = Double.POSITIVE_INFINITY;
            Vector3D centroid = null;
            if (Double.isFinite(this.volumeSum) && this.volumeSum > 0.0) {
                size = this.volumeSum / 3.0;
                double centroidScale = 1.0 / (4.0 * size);
                centroid = Vector3D.of(this.sumX * centroidScale, this.sumY * centroidScale, this.sumZ * centroidScale);
            }
            return new AbstractRegionBSPTree.RegionSizeProperties(size, centroid);
        }

        private void addBoundaryContribution(HyperplaneSubset<Vector3D> boundary, boolean reverse) {
            PlaneSubset boundarySubset = (PlaneSubset)boundary;
            Plane boundaryPlane = boundarySubset.getPlane();
            double boundaryArea = boundarySubset.getSize();
            Vector3D boundaryCentroid = (Vector3D)boundarySubset.getCentroid();
            if (Double.isInfinite(boundaryArea)) {
                this.volumeSum = Double.POSITIVE_INFINITY;
            } else if (boundaryCentroid != null) {
                double scaledVolume = boundaryArea * boundaryCentroid.dot(boundaryPlane.getNormal());
                if (reverse) {
                    scaledVolume = -scaledVolume;
                }
                this.volumeSum += scaledVolume;
                this.sumX += scaledVolume * boundaryCentroid.getX();
                this.sumY += scaledVolume * boundaryCentroid.getY();
                this.sumZ += scaledVolume * boundaryCentroid.getZ();
            }
        }
    }

    private static final class BoundaryProjector3D
    extends AbstractRegionBSPTree.BoundaryProjector<Vector3D, RegionNode3D> {
        private BoundaryProjector3D(Vector3D point) {
            super((Point)point);
        }

        protected Vector3D disambiguateClosestPoint(Vector3D target, Vector3D a, Vector3D b) {
            int cmp = Vector3D.COORDINATE_ASCENDING_ORDER.compare(a, b);
            return cmp < 0 ? a : b;
        }
    }

    public static final class PartitionedRegionBuilder3D
    extends AbstractPartitionedRegionBuilder<Vector3D, RegionNode3D> {
        private PartitionedRegionBuilder3D() {
            super((AbstractRegionBSPTree)RegionBSPTree3D.empty());
        }

        public PartitionedRegionBuilder3D insertPartition(Plane partition) {
            return this.insertPartition(partition.span());
        }

        public PartitionedRegionBuilder3D insertPartition(PlaneConvexSubset partition) {
            this.insertPartitionInternal(partition);
            return this;
        }

        public PartitionedRegionBuilder3D insertAxisAlignedPartitions(Vector3D center, Precision.DoubleEquivalence precision) {
            this.insertPartition(Planes.fromPointAndNormal(center, Vector3D.Unit.PLUS_X, precision));
            this.insertPartition(Planes.fromPointAndNormal(center, Vector3D.Unit.PLUS_Y, precision));
            this.insertPartition(Planes.fromPointAndNormal(center, Vector3D.Unit.PLUS_Z, precision));
            return this;
        }

        public PartitionedRegionBuilder3D insertAxisAlignedGrid(Bounds3D bounds, int level, Precision.DoubleEquivalence precision) {
            this.insertAxisAlignedGridRecursive((Vector3D)bounds.getMin(), (Vector3D)bounds.getMax(), level, precision);
            return this;
        }

        private void insertAxisAlignedGridRecursive(Vector3D min, Vector3D max, int level, Precision.DoubleEquivalence precision) {
            if (level > 0) {
                Vector3D center = min.lerp(max, 0.5);
                this.insertAxisAlignedPartitions(center, precision);
                int nextLevel = level - 1;
                this.insertAxisAlignedGridRecursive(min, center, nextLevel, precision);
                this.insertAxisAlignedGridRecursive(center, max, nextLevel, precision);
            }
        }

        public PartitionedRegionBuilder3D insertBoundary(PlaneConvexSubset boundary) {
            this.insertBoundaryInternal(boundary);
            return this;
        }

        public PartitionedRegionBuilder3D insertBoundaries(Iterable<? extends PlaneConvexSubset> boundaries) {
            for (PlaneConvexSubset planeConvexSubset : boundaries) {
                this.insertBoundaryInternal(planeConvexSubset);
            }
            return this;
        }

        public PartitionedRegionBuilder3D insertBoundaries(BoundarySource3D boundarySrc) {
            try (Stream stream = boundarySrc.boundaryStream();){
                stream.forEach(arg_0 -> ((PartitionedRegionBuilder3D)this).insertBoundaryInternal(arg_0));
            }
            return this;
        }

        public RegionBSPTree3D build() {
            return (RegionBSPTree3D)this.buildInternal();
        }
    }

    public static final class RegionNode3D
    extends AbstractRegionBSPTree.AbstractRegionNode<Vector3D, RegionNode3D> {
        RegionNode3D(AbstractBSPTree<Vector3D, RegionNode3D> tree) {
            super(tree);
        }

        public ConvexVolume getNodeRegion() {
            RegionNode3D parent;
            ConvexVolume volume = ConvexVolume.full();
            RegionNode3D child = this;
            while ((parent = (RegionNode3D)child.getParent()) != null) {
                Split<ConvexVolume> split = volume.split((Hyperplane<Vector3D>)parent.getCutHyperplane());
                volume = child.isMinus() ? (ConvexVolume)split.getMinus() : (ConvexVolume)split.getPlus();
                child = parent;
            }
            return volume;
        }

        protected RegionNode3D getSelf() {
            return this;
        }
    }
}

