/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.AbstractConvexHyperplaneBoundedRegion;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.Plane;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.RegionBSPTree3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;

public class ConvexVolume
extends AbstractConvexHyperplaneBoundedRegion<Vector3D, PlaneConvexSubset>
implements BoundarySource3D {
    private static final ConvexVolume FULL = new ConvexVolume(Collections.emptyList());

    protected ConvexVolume(List<PlaneConvexSubset> boundaries) {
        super(boundaries);
    }

    public Stream<PlaneConvexSubset> boundaryStream() {
        return this.getBoundaries().stream();
    }

    public double getSize() {
        if (this.isFull()) {
            return Double.POSITIVE_INFINITY;
        }
        double volumeSum = 0.0;
        for (PlaneConvexSubset boundary : this.getBoundaries()) {
            if (boundary.isInfinite()) {
                return Double.POSITIVE_INFINITY;
            }
            Plane boundaryPlane = boundary.getPlane();
            double boundaryArea = boundary.getSize();
            Vector3D boundaryCentroid = (Vector3D)boundary.getCentroid();
            volumeSum += boundaryArea * boundaryCentroid.dot(boundaryPlane.getNormal());
        }
        return volumeSum / 3.0;
    }

    public Vector3D getCentroid() {
        double volumeSum = 0.0;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        for (PlaneConvexSubset boundary : this.getBoundaries()) {
            if (boundary.isInfinite()) {
                return null;
            }
            Plane boundaryPlane = boundary.getPlane();
            double boundaryArea = boundary.getSize();
            Vector3D boundaryCentroid = (Vector3D)boundary.getCentroid();
            double scaledVolume = boundaryArea * boundaryCentroid.dot(boundaryPlane.getNormal());
            volumeSum += scaledVolume;
            sumX += scaledVolume * boundaryCentroid.getX();
            sumY += scaledVolume * boundaryCentroid.getY();
            sumZ += scaledVolume * boundaryCentroid.getZ();
        }
        if (volumeSum > 0.0) {
            double size = volumeSum / 3.0;
            double centroidScale = 1.0 / (4.0 * size);
            return Vector3D.of(sumX * centroidScale, sumY * centroidScale, sumZ * centroidScale);
        }
        return null;
    }

    public Split<ConvexVolume> split(Hyperplane<Vector3D> splitter) {
        return this.splitInternal(splitter, this, PlaneConvexSubset.class, ConvexVolume::new);
    }

    @Override
    public RegionBSPTree3D toTree() {
        return RegionBSPTree3D.from(this.getBoundaries(), true);
    }

    public PlaneConvexSubset trim(HyperplaneConvexSubset<Vector3D> convexSubset) {
        return (PlaneConvexSubset)super.trim(convexSubset);
    }

    public ConvexVolume transform(Transform<Vector3D> transform) {
        return (ConvexVolume)this.transformInternal(transform, this, PlaneConvexSubset.class, ConvexVolume::new);
    }

    public static ConvexVolume full() {
        return FULL;
    }

    public static ConvexVolume fromBounds(Plane ... planes) {
        return ConvexVolume.fromBounds(Arrays.asList(planes));
    }

    public static ConvexVolume fromBounds(Iterable<? extends Plane> boundingPlanes) {
        List facets = new AbstractConvexHyperplaneBoundedRegion.ConvexRegionBoundaryBuilder(PlaneConvexSubset.class).build(boundingPlanes);
        return facets.isEmpty() ? ConvexVolume.full() : new ConvexVolume(facets);
    }
}

