/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import org.apache.commons.compress.compressors.bzip2.BZip2Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BZip2UtilsTest {
    BZip2UtilsTest() {
    }

    @Test
    void testGetCompressedFilename() {
        Assertions.assertEquals((Object)".bz2", (Object)BZip2Utils.getCompressedFilename((String)""));
        Assertions.assertEquals((Object)".bz2", (Object)BZip2Utils.getCompressedFileName((String)""));
        Assertions.assertEquals((Object)" .bz2", (Object)BZip2Utils.getCompressedFilename((String)" "));
        Assertions.assertEquals((Object)" .bz2", (Object)BZip2Utils.getCompressedFileName((String)" "));
        Assertions.assertEquals((Object)"x.bz2", (Object)BZip2Utils.getCompressedFilename((String)"x"));
        Assertions.assertEquals((Object)"x.bz2", (Object)BZip2Utils.getCompressedFileName((String)"x"));
        Assertions.assertEquals((Object)"X.bz2", (Object)BZip2Utils.getCompressedFilename((String)"X"));
        Assertions.assertEquals((Object)"X.bz2", (Object)BZip2Utils.getCompressedFileName((String)"X"));
        Assertions.assertEquals((Object)"x.tar.bz2", (Object)BZip2Utils.getCompressedFilename((String)"x.tar"));
        Assertions.assertEquals((Object)"x.tar.bz2", (Object)BZip2Utils.getCompressedFileName((String)"x.tar"));
        Assertions.assertEquals((Object)"x.tar.bz2", (Object)BZip2Utils.getCompressedFilename((String)"x.TAR"));
        Assertions.assertEquals((Object)"x.tar.bz2", (Object)BZip2Utils.getCompressedFileName((String)"x.TAR"));
    }

    @Test
    void testGetUncompressedFilename() {
        Assertions.assertEquals((Object)"", (Object)BZip2Utils.getUncompressedFilename((String)""));
        Assertions.assertEquals((Object)"", (Object)BZip2Utils.getUncompressedFileName((String)""));
        Assertions.assertEquals((Object)".bz2", (Object)BZip2Utils.getUncompressedFilename((String)".bz2"));
        Assertions.assertEquals((Object)".bz2", (Object)BZip2Utils.getUncompressedFileName((String)".bz2"));
        Assertions.assertEquals((Object)"x.tar", (Object)BZip2Utils.getUncompressedFilename((String)"x.tbz2"));
        Assertions.assertEquals((Object)"x.tar", (Object)BZip2Utils.getUncompressedFileName((String)"x.tbz2"));
        Assertions.assertEquals((Object)"x.tar", (Object)BZip2Utils.getUncompressedFilename((String)"x.tbz"));
        Assertions.assertEquals((Object)"x.tar", (Object)BZip2Utils.getUncompressedFileName((String)"x.tbz"));
        Assertions.assertEquals((Object)"x", (Object)BZip2Utils.getUncompressedFilename((String)"x.bz2"));
        Assertions.assertEquals((Object)"x", (Object)BZip2Utils.getUncompressedFileName((String)"x.bz2"));
        Assertions.assertEquals((Object)"x", (Object)BZip2Utils.getUncompressedFilename((String)"x.bz"));
        Assertions.assertEquals((Object)"x", (Object)BZip2Utils.getUncompressedFileName((String)"x.bz"));
        Assertions.assertEquals((Object)"x.tar", (Object)BZip2Utils.getUncompressedFilename((String)"x.TBZ2"));
        Assertions.assertEquals((Object)"x.tar", (Object)BZip2Utils.getUncompressedFileName((String)"x.TBZ2"));
        Assertions.assertEquals((Object)"X.tar", (Object)BZip2Utils.getUncompressedFilename((String)"X.Tbz2"));
        Assertions.assertEquals((Object)"X.tar", (Object)BZip2Utils.getUncompressedFileName((String)"X.Tbz2"));
        Assertions.assertEquals((Object)"X.tar", (Object)BZip2Utils.getUncompressedFilename((String)"X.tbZ2"));
        Assertions.assertEquals((Object)"X.tar", (Object)BZip2Utils.getUncompressedFileName((String)"X.tbZ2"));
        Assertions.assertEquals((Object)"x.bz ", (Object)BZip2Utils.getUncompressedFilename((String)"x.bz "));
        Assertions.assertEquals((Object)"x.bz ", (Object)BZip2Utils.getUncompressedFileName((String)"x.bz "));
        Assertions.assertEquals((Object)"x.tbz\n", (Object)BZip2Utils.getUncompressedFilename((String)"x.tbz\n"));
        Assertions.assertEquals((Object)"x.tbz\n", (Object)BZip2Utils.getUncompressedFileName((String)"x.tbz\n"));
        Assertions.assertEquals((Object)"x.tbz2.y", (Object)BZip2Utils.getUncompressedFilename((String)"x.tbz2.y"));
        Assertions.assertEquals((Object)"x.tbz2.y", (Object)BZip2Utils.getUncompressedFileName((String)"x.tbz2.y"));
    }

    @Test
    void testIsCompressedFilename() {
        Assertions.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)""));
        Assertions.assertFalse((boolean)BZip2Utils.isCompressedFileName((String)""));
        Assertions.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)".gz"));
        Assertions.assertFalse((boolean)BZip2Utils.isCompressedFileName((String)".gz"));
        Assertions.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.tbz2"));
        Assertions.assertTrue((boolean)BZip2Utils.isCompressedFileName((String)"x.tbz2"));
        Assertions.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.tbz"));
        Assertions.assertTrue((boolean)BZip2Utils.isCompressedFileName((String)"x.tbz"));
        Assertions.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.bz2"));
        Assertions.assertTrue((boolean)BZip2Utils.isCompressedFileName((String)"x.bz2"));
        Assertions.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.bz"));
        Assertions.assertTrue((boolean)BZip2Utils.isCompressedFileName((String)"x.bz"));
        Assertions.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)"xbz2"));
        Assertions.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)"xbz2"));
        Assertions.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)"xbz"));
        Assertions.assertFalse((boolean)BZip2Utils.isCompressedFileName((String)"xbz"));
        Assertions.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.TBZ2"));
        Assertions.assertTrue((boolean)BZip2Utils.isCompressedFileName((String)"x.TBZ2"));
        Assertions.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.Tbz2"));
        Assertions.assertTrue((boolean)BZip2Utils.isCompressedFileName((String)"x.Tbz2"));
        Assertions.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.tbZ2"));
        Assertions.assertTrue((boolean)BZip2Utils.isCompressedFileName((String)"x.tbZ2"));
        Assertions.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)"x.bz "));
        Assertions.assertFalse((boolean)BZip2Utils.isCompressedFileName((String)"x.bz "));
        Assertions.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)"x.tbz\n"));
        Assertions.assertFalse((boolean)BZip2Utils.isCompressedFileName((String)"x.tbz\n"));
        Assertions.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)"x.tbz2.y"));
        Assertions.assertFalse((boolean)BZip2Utils.isCompressedFileName((String)"x.tbz2.y"));
    }
}

